Several observations are in order. Recall that f*(fi) is the conjugate of the concave function f (the exponent), and is therefore also concave; for this reason -f*(f;) is convex.  In Appendix C we prove that the remaining term:

$$\log\ E\quad e\quad{\mathrm{~}}_{j,i\leq m}\,\xi\,_{i}\theta\,_{i j}\,d_{j}$$
$$\left(45\right)$$

is also a convex function of the variational parameters.  Now, since any sum of convex functions is convex, we conclude that log P(f+l£) is a convex function of the variational parameters. This means that there are no local minima in our optimization problem. We may safely employ the standard Newton-Raphson procedure to solve ∇ log P ( f + | ξ) = 0.

Alternatively we can utilize fixed-point iterations. In particular, we calculate the derivatives of the variational form and iteratively solve for the individual variational parameters ξ k such that the derivatives are zero. The derivatives are given as follows:

$$\frac{\partial}{\partial\xi_{\,k}}\log P(f^{+}|\xi)=\theta_{k0}+\log\frac{\xi_{\,k}}{1+\xi_{\,k}}+E\qquad\theta_{kj}\,d_{j}\tag{46}$$ $$\frac{\partial^{2}}{\partial^{2}\xi_{\,k}}\log P(f^{+}|\xi)=\frac{1}{\xi_{\,k}}-\frac{1}{1+\xi_{\,k}}+\mbox{V}\,ar\qquad\theta_{kj}\,d_{j}\quad,\tag{47}$$

where the expectation and the variance are with respect to the posterior approximation P(dlf+,{), and both derivatives can be computed in time linear in the number of associated diseases for the finding. The benign scaling of the variance calculations comes from exploiting the special properties of the noisy-OR dependence and the marginal independence of the diseases.

Calculating the expectations in Eq. (7) is exponentially costly in the number of exactly treated positive findings. When there are alarge number of positive findings, we can have recourse to a simplified procedure in which we optimize variational parameters after having transformed all or most of the positive findings. While the resulting vanational parameters are suboptimal, we have found in practice that the incurred loss in accuracy is typically quite small. In the simulations reported in the paper, we optimized the variational parameters after approximately half of the exactly treated findings had been introduced. (To be precise, in the case of 8, 12 and 16 total findings treated exactly, we optimized the parameters after 4, 8, and 8 findings, respectively, were introduced).

## Lower  Bound  Transformations

Mimicking the case of upper bounds, we replace individual conditional probabilities of the findings with lower-bounding transformations, resulting in a lower-bounding expression P(f+ld, q). Taking the product with P(d) and marginalizing over d yields a lower bound on the likelihood:

$$P(f^{+})\geq\quad\operatorname*{P}_{d}(f^{+}|d,\,q)P(d)\equiv P(f^{+}|\,q).$$
$$(48)$$

We wish to maximize P(f+lq) with respect to the variational parameters q to obtain the tightest possible bound.