
## 3. Inference

Carrying out diagnostic inference in the QMR model involves computing the posterior marginal probabilities of the diseases given a set of observed positive (fi = 1) and negative (fir = 0) findings. Note that the set of observed findings is considerably smaller than the set of possible findings; note moreover (from the bi-partite structure of the QMR-DT graph)
that unobserved findings have no effect on the posterior probabilities for the diseases. For brevity we adopt a notation in which f,+ corresponds to the event f, = 1, and f,- refers to f i = 0 (positive and negative findings respectively). Thus the posterior probabilities of interest are P(djlf+,f-), where f+ and f- are the vectors of positive and negative findings.

The negative findings f- are benign with respect to the inference problem they can be incorporated into the posterior probability in linear time in the number of associated diseases and in the number of negative findings. As we discuss below, this can be seen from the fact that the probability of a negative finding in Eq. (4) is the exponential of an expression that is linear in the d i . The positive findings, on the other hand, are more problematic. In the worst case the exact calculation of posterior probabilities is exponentially costly in the nmber of positive findings (Heckerman, 1989; D'Ambrosio, 1994). Moreover, in practical diagnostic situations the number of positive findings often exceeds the feasible limit for exact calculations.

Let us consider the inference calculations in more detail. To find the posterior probability P(dlf+,f-), we first absorb the evidence from negative findings, i.e., we compute P(dlf-).

This is just P(f-[d)P(d) with normalization. Since both P(f-[d) and P(d) factorize over the diseases (see Eq. (1) and Eq. (2) above), the posterior P(d [f-) must factorize as well.

The normalization of P(f-ld)P(d) therefore reduces to independent normalizations over each disease and can be carried out in time linear in the number of diseases (or negative findings). In the remainder of the paper, we concentrate solely on the positive findings as they pose the real computational challenge. Unless otherwise stated, we assume that the prior distribution over the diseases already contains the evidence from the negative findings.

In other words, we presume that the updates P(dj) ← P(dj|f-) have already been made.

We now turn to the question of computing P(djlf+), the posterior marginal probability based on the positive findings. Formally, obtaining such a posterior involves marginalizing P(f+[d)P(d) across the remaining diseases:

$$P(d_{j}|f^{+})\propto\operatorname*{Pr}_{d\setminus d_{j}}P(f^{+}|d)P(d)$$
$$\left({5\atop)}\right)$$

where the summation is over all the possible configurations of the disease vanables other than dj (we use the shorthand summation index d \ dj for this). In the QMR model P(f+|d)P(d) has the form:

$$\begin{array}{r c l}{{P(f^{+}|\,d)P(d)}}&{{=}}&{{\quad\quad P(f_{i}^{+}|\,d)\quad\quad\quad P(d_{j})}}\\ {{}}&{{}}&{{}}\\ {{}}&{{}}&{{i}}\end{array}$$
$$\left(\,6\,\right)$$
; Oi j d j P(d j )
$$\left(7\right)$$
$$296$$
