# Extensible Knowledge Representation: The Case Of Description Reasoners

Alex Borgida **borgida@cs.rutgers.edu**
Dept. of Computer Science Rutgers University New Brunswick, NJ 08904 USA

## Abstract

This paper offers an approach to extensible knowledge representation and reasoning for the Description Logic family of formalisms. The approach is **based on the notion of adding** new concept constructors, and includes a heuristic methodology for specifying the desired extensions, as well as a modularized software architecture **that supports implementing** extensions. The architecture detailed here falls in the normalize-compared paradigm, and supports both intentional reasoning (subsumption) involving concepts, and extensional reasoning involving individuals after incremental updates to the knowledge base.

The resulting approach can be used to extend the reasoner with specialized notions that are motivated by specific problems or application areas, such as reasoning about dates, plans, etc. In addition, it provides an opportunity to implement constructors that are not currently yet sufficiently well understood theoretically, but are needed in practice. Also, for constructors that are provably hard to reason with **(e.g., ones whose presence** would lead to undecidability), it allows the implementation of incomplete reasoners where the incompleteness is tailored to be acceptable for the application at hand.

## 1. Introduction And Motivation

Description Logics (DLs) are a family of object-centered formalisms for representing knowledge about and reasoning with individuals grouped into classes (here called concepts**) and**
related by binary relations (here called roles**). Descriptions usually have a term-like notation that uses concept constructors and identifiers to build definitions of more complex**
concepts from simpler ones. For example, the description in **Figure 1 is supposed to capture** the noun phrase "A collection of objects that are books and that are written by two or more authors, who are all Venusians".

## And(

BOOK
at-least**(2,authoredBy)**
all**(authoredBy, VENUSIAN) )**
Figure 1: An example description.

This is accomplished by using the concept constructor and **to conjoin terms that represent**
component notions:
c 1999 AI Access Foundation and Morgan Kaufmann Publishers. All rights reserved.