/* if any Normalize or Conjoin detects an incoherence, propagate it up, since the whole conjunct is incoherent. */
} catch IncoherentExn { **throw IncoherentExn** }
return ND;
Conjoin(fromNC, ontoNC: <NormalizedConcept>**) throws IncoherentExn**
/* Take each component of **fromNC** and conjoin it to **ontoNC**;
modifies ontoNC. */
{For every Q**(T) in getComponents(fromNC) do**
{Q**::Conjoin( T, ontoNC)** } catch IncoherentExn {**throw IncoherentExn** }
}
Therefore, for every constructor Q, we also expect corresponding functions Q**::Normalize** and Q::Conjoin **. Note that the software architecture treats incoherent concepts (ones**
equivalent to nothing) in a special manner: whenever they are encountered, a special exception IncoherentExn is raised. Conjunction propagates these exceptions, but other constructors may trap them and handle them in their own way. For example, all**::Normalize**
accepts the restriction being incoherent, but must ensure that at-most**(0) is also added to**
the normalized concept for the same role.

In retrospect, the above three functions (Subsumes?, Normalize and Conjoin**) really**
represent the semantics of the constructor and **(and hence can be appropriately called**
and::Subsumes?**, etc.) as well as the expansion of necessary conditions/definitions for**
named concepts ("inheritance"), and parts of the meaning of the built-in concepts nothing and thing. To make this more complete, we can add to the beginning of the **Subsumes?** function the statement: if equal(hiNC,NormalFormthing) or equal(lowNC,NormalForm nothing**) then return true;**
In this sense, protodl **starts from a minimal, core language specified by the syntax**
C ::= thing | nothing | CN | (and C1**, . . ., C**n)
This is not to say that everyone must start from this minimalist language, which is hardly useful. But it will have the advantage that all constructors **(even the most useful ones,**
like all, at-least**, etc.) will be implemented as extensions, according to the same uniform**
paradigm as the more esoteric extensions. This will be essential if we are to be able to easily modify the implementation of standard constructors (like all**) when called upon to**
implement non-standard ones (like dates), which may interact with them.

## 3.2 An Overview Of The Process Of Extension.

Suppose we want to extend the system at some particular stage **with a new concept constructor. The following is a suggested methodology for accomplishing this, illustrated with**
a familiar concept constructor, all.