(1) Determine a syntax for the extension. **If concepts will have a LISP-like syntax (as in**
classic and loom), the constructor all might be given the syntax (:all **Role Concept**).

The terms following the constructor are called its arguments**, and a version of them will**
eventually be stored in the internal representation of our normalized concepts. One can now implement the function all::Parse, which in this case would invoke Role::parse and Concept::parse.

(2) Determine a semantics for the new concept constructor.

First, this requires settling on a domain of values from which its denotation will come. This might be the set of ordinary objects with unique intrinsic identity - instances of a special class any-object, which is a built-in direct subclass of thing**. The denotation might also**
be some new kind of value (e.g., triples for dates, or lists of **objects), in which case it is** necessary to introduce (possibly as a new concept constructor, which takes no argument) a top class for these kinds of values (e.g., any-date **for dates).**
It is now time to clarify the intended meaning of the new constructors. One alternative, not explored here, is to express the semantics using First Order Predicate Calculus. Another is to assign a denotation of values to concepts built with the new constructor. For all**, this**
is just the usual interpretation all(**p, C**)
I = { d ∈ ∆I| p I(d) ⊆ CI }
Rather than move on to implementation right away, our experience indicates that it is easier to first describe the deductions to be performed in a more concise manner: through rules of inference. Based on empirical evidence, we see these rules of inference as being naturally grouped into several categories4
- Rules dealing with just one constructor, Q.

- Normalizing the arguments of Q**, if these are themselves composite objects.**

$$\frac{C\,\equiv\,D}{\mathrm{\bf~all}(p,C)\,\equiv\,\mathrm{\bf~all}(p,D)}$$

- Reasoning only with concepts of the form Q(args).

∗ **When is such a concept incoherent** by itself?

all(p, C**) is never incoherent**.

∗ **When is such a concept equivalent to the entire domain of values?**
all(p, thing) ≡ **any-object**

∗ When does Q(arg1) subsume Q**(arg2) in terms of arg1 and arg2? (The socalled structural subsumption relationship.)**
C =⇒ D
all(p, C) =⇒ all(**p, D**)