Q::Subsumes?(T:<NormalizedQ-Term>, lower:<**NormalizedConcept**>)
returns <**Bool**>
{if not Q::SubsumesSame?(T,get Q**(lower)) then return false;**
if not Q**::SubsumesDifferent?(T,lower) then return false;** return true; }
Of course, if a specific constructor does not need to implement some of these subprocedures, the corresponding lines from the generic implementations are omitted, in order to avoid the cost of useless function invocations.

For our simple example, when Q=all, all::Normalize(all(role,vr)) **returns**
all(role, and**::Normalize(vr))**.

If the only other constructor is at-most, the following functions used by all**:Conjoin**
and all::Subsumes? **are needed:**
- Q**::Universal?(T)**: Is T equivalent to the top of the hierarchy for that set of values?

all::Universal?(all(role,vr)) returns true when vr is NormalForm**thing**.

- Q**::SubsumesSame?(T,OldTs)**: Is T implied by the Q-constructed terms already seen in oldTs? **This is basically the "structural subsumption" algorithm.**
all::SubsumesSame?(all(role,vr1),all(role,vr2)) **would return true iff**
and::Subsumes?(vr1,vr2) **returns true.**
- Q**::ConjoinToSame(T,OldTs)**: Merge T with any preceding terms built with Q.

all::ConjoinToSame(all(role,vr1),all(role,vr2)) **returns**
all(role,and**::Conjoin(vr1,vr2))**.

- Q**::FindOtherImplications(T,This,ImplicationsToDoList)**: If any additional constructors have to be added because of Q, put them onto the **ImplicationsToDoList**.

all::FindOtherImplications adds to ImplicationsToDoList **the description**
at-most(0,role) if its first argument is all(role,**nothing**).
Once the Conjoin, Normalize and Subsumes? **functions are implemented for the new**
constructor Q, the corresponding functions for and **need to have lines added to invoke**
them according to the pattern presented in the preceding section (unless the programming language is highly polymorphic).

Next, we use reasoning about dates, an extension desired in some classic **applications,**
to give a more complex example of the methodology for building extensions of **protodl**.

## 3.3 Dates: An Example Concept-Level Extension

We imagine an application where there will be individual dates as values of attributes or even roles, and that concepts will describe collections of dates, specified in various ways (e.g., as ranges or periods).

To begin with, it is important to clarify what the individuals **look like about which**
information will be kept. In the case of dates, we know that we **wish to treat them as**
temporal points, which have associated information about the year, month and day when that date occurs. Given a date d**, the above components will be referred to as year(**d),