month(d), day(d**). There are two different ways of thinking of a date: as an abstract**
mathematical value (e.g., a triple of integers) or as an individual object with attributes for year, month, day. **The last approach has the disadvantage that we need to develop a** separate theory of identity for dates (two dates are supposed to be identical if they have the same components), although it has the advantage of allowing incomplete information about the exact occurrence of a time point. Since this feature is not desired, we will adopt the first approach, for convenience writing date individuals as 1996/7/25. In addition, we will have the usual total (reflexive) order  **on dates, as well as two special date constants,**
BeginTime and EndTime, such that BeginTime  d  **EndTime for all dates** d.

We are now ready to introduce concept-forming operators for **dates which are useful for**
our application. First, when introducing a new kind **of value, it is useful to define a top**
concept, which will contain all such values. In our case, let us call it **any-date**.

One obvious grouping of dates is by ranges: "between June 1st **and August 31, 1996".**
We might thus propose a concept constructor dateRange**, which takes as argument a pair of**
dates, denoting the ends of the range, e.g., dateRange(1996/6/1,1996/8/31)**. But since**
the base language does not support disjunction, and we want to allow descriptions such as
"the summers of 1995 and 1996", we will in fact have dateRange **take as argument a set**
of date pairs, as in dateRange({**(1995/6/1,1995/8/31) , (1996/6/1,1996/8/31)**}).

Having established the syntax of the concept constructors, and then implemented dateRange::Parse**, we present its denotational semantics:**
dateRange(SD)
I = { d | ∃b, e.(b, e) ∈ **SD such that b**  d  e }
Next, we look for inference rules describing the desired reasoning for dateRange**. Following the heuristics in Section 3.2, we come up with Table 3.**
To implement the inferences for dateRange, we must find a normal form and write functions dateRange::Normalize, dateRange::Conjoin and dateRange::Subsumes?**, or**
their components.

It is useful to determine first the structural subsumption function, dateRange::-
SubsumesSame?**, since this drives the requirements for the others. In our case, the obvious** representation works fine: a date is some data structure, such as a list of three values or a record with three fields; a single date-pair is a list of two values or a record with two fields; and the set of date-pairs making up the disjunction is **just a list of date-pairs. It is**
best to encapsulate the above implementation choices using abstract data types for **Date,**
DatePair and DateRange, with appropriate accessor functions and constructors. We **must**
also extend the representation of normalized concepts to implement put dateRange and get **dateRange**.

Returning to dateRange::SubsumesSame?**, this function now simply implements the**
subsumption inference rules above dateRange::SubsumesSame?(high,low : <SET(Date×Date)> ): returns <**Bool**>
{**for every (b,e) in low**
find (b',e') in high such that b'  b  e  e';
}