
| Universal                                                                                                                                             | dateRange({(BeginTime,EndTime)})                | ≡                  | any-date   |    |
|-------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------|--------------------|------------|----|
| Incoherent                                                                                                                                            | dateRange({})                                   | ≡                  | nothing    |    |
| Subsumption                                                                                                                                           | b1                                              |  b2                    |  e2            |  e1    |
| dateRange({(b2,e2)}) =⇒ dateRange({(b1,e1)}) dateRange(α1 ) =⇒ dateRange(α2) dateRange(β1) =⇒ dateRange(β2 ) dateRange(α1 ∪ β1) =⇒ dateRange(α2 ∪ β2) |                                                 |                    |            |    |
| Conjunction                                                                                                                                           | and(dateRange({(b2,e2)}), dateRange({(b1,e1)})) | ≡                  |            |    |
| dateRange({ (max(b1,b2),min(e1,e2))}) and(dateRange(α),dateRange(β1)) ≡ dateRange(γ1) and(dateRange(α),dateRange(β2)) ≡ dateRange(γ2)                 |                                                 |                    |            |    |
| and( dateRange(α), dateRange(β1 ∪ β2))                                                                                                                | ≡                                               | dateRange(γ1 ∪ γ2) |            |    |
| Normalize                                                                                                                                             | e                                               |  (b + 1 day)                    |            |    |
| dateRange({(b,e),α})                                                                                                                                  | ≡ dateRange({α})                                |                    |            |    |
| b1                                                                                                                                                    |  b2                                                 |  (e1 + 1 day)                    |  e2            |    |
| dateRange({(b1,e1),(b2,e2)})                                                                                                                          | ≡ dateRange({(b1,e2)})                          |                    |            |    |

dateRange::Normalize **verifies (if not already done so) that the dates b and e in**
each pair (b,e) are valid according to our usual calendar, and that b  **e. Any pairs not**
satisfying these conditions are eliminated. It also needs to merge overlapping or adjacent intervals into maximally long ones, since otherwise the above subsumption algorithm will not recognize that dateRange({(1996/1/2,1996/1/4), (1996/1/5,1996/1/6)}) **subsumes**
dateRange({**1996/1/2, 1996/1/6**}).

The function dateRange::Conjoin **has the standard implementation (see Appendix**
A), but only functions dateRange::Universal?, dateRange::Incoherent?, **dateRange**-
::ConjoinToSame and dateRange::SubsumesSame? **need to be implemented, performing**
exactly the actions specified by the rules of inference.

Consider now adding another concept constructor for dates, **to help represent** periodic time, such as "every summer" or "every Christmas". A single period is just a range constraint on the possible values for the components of a date, other than year**. So, "summer**
days" would be represented by [(6 . 8) (1 . 31)], while "Christmas" would be [(12 . 12)
(25 . 25)]. For the sake of brevity, this new period **constructor will take as argument**
only a single period (rather than a set of them, interpreted disjunctively) and we will only sketch the implementation extensions. Also not presented here, is a very useful extension to