
| Universal                                                             | period([(1 . 12) (1 . 31)])   | ≡ any-date    |                       |
|-----------------------------------------------------------------------|-------------------------------|---------------|-----------------------|
| Incoherent                                                            | not( bm ≤ em                  | and bd ≤ ed ) |                       |
| period([(bm.em) (bd.ed)])                                             | ≡ nothing                     |               |                       |
| Subsumption                                                           | bm1 ≤ bm2 ≤ em2 ≤ em1         | and           | bd1 ≤ bd2 ≤ ed2 ≤ ed1 |
| period([(bm2.em2)(bd2.ed2)]) =⇒ period([(bm1.em1)(bd1.ed1)])          |                               |               |                       |
| and(period([(bm1.em1)(bd1.ed1)]),                                     | period([(bm2.em2)(bd2.ed2)])) |               |                       |
| ≡                                                                     |                               |               |                       |
| period([(max(bm1,bm2) . min(em1,em2)) (max(bd1,bd2) . min(ed1,ed2))]) |                               |               |                       |
| Conjunction                                                           |                               |               |                       |

periods allowing constraints on the days of the week, such as **"every Saturday to Sunday",**
or even "every 3rd Sunday".

The denotation of period **terms is also quite simple:**
period([(m1.m2)(d1.d2)])I = {e | m1 ≤ month(e) ≤ m2, d1 ≤ day(e) ≤ d2}
The rules of inference for reasoning about period **concepts alone, presented in Table 4**
are also straightforward. The implementation of most functions follows immediately from the rules of inference.

The interesting reasoning involves the conjunction of ranges with periods. These rules, appearing in Figure 5, can be expressed most succinctly by showing how certain periods are either eliminated or retained unchanged, and then relying on the dateRange **normalization rule, applied** in reverse**, to cut up a range into appropriate strips. These inference**
rules imply that we need to also implement period::ConjoinToDifferent (p:<**Period**>,
other:<NormalizedConcept>)**, which basically uses the period as a "cookie cutter" to**
create the sub-interval ranges that satisfy the period's restriction. Of course, this will be done procedurally in a manner more efficient than suggested **by the rules of inference.**
Moreover, we must now revisit the implementation of dateRange, to put in a similar dateRange::ConjoinToDifferent **function, since a concept with a range may be conjoined**
onto one that already has a period in it.

Finally, in the presence of both dateRange and period constructors, structural subsumption is not enough, since we want period([(4 . 4) (1 . 31)]) to subsume dateRange((1988/4/1, 1988/4/21)), but not dateRange((1990/4/1, 1992/4/1))**, and**
there is no finite normal form which would list all the ranges satisfying a period. So we need to also write the function period::Subsumes Different?(p:<Period>, lower:<NormalizedConcept>), which checks every interval (b,e) in get dateRange(lower) **to make**
sure that year(b)=year(e) **and that the month and day meet the conditions of the period.**
An interesting complication arises because dates are discrete, and hence one can count the number of dates in a dateRange. If dateRange **can appear as the value restriction**