

![0_image_0.png](0_image_0.png)

of general roles, as in all(freeForMeeting, dateRange({(1995/6/1,1996/6/5)})) **attributes, there is no problem. Otherwise, we can however infer cardinality constraints on**
the number of fillers: dateRange({(1995/6/1,1996/6/5)}) allows only 5 different values. In a language that supports constructor at-most**, we would therefore have to conclude**
at-most(5,freeForMeeting)**. The implementation achieves this by introducing a helper**
function dateRange::countDays, which can be applied to a normalized dateRange object; then, function all::FindOtherImplications **needs to be modified, so that it invokes**
dateRange::countDays **on its value restriction if it is of date type, and a normalized**
at-most restriction is posted for that role on the ImplicationsToDoList. Later processing of that list will remove the at-most **constraint and conjoin it onto the concept.**

## 3.4 Experience With Extensions

As part of the development of the above architecture, we have **considered extending the**
original core with the constructors of classic (all, at-least, at-most, fills, one-of**, integer**
ranges), as well as primitive concept negation, and the negation of fills**. In these cases we**
have reproduced the inferences of classic **and almost exactly the internal actions of the**
classic **implementation; i.e., we perform only a few more checks despite the fact that our**
implementation is made up of "standard" modules for each constructor.

Two kinds of concept constructors seem difficult to add to a normalize-compare algorithm in a way that preserves completeness of reasoning and **the architecture of the system.**
Disjunction would most naturally be handled if there was a disjunctive normal form, where each disjunct is purely conjunctive. This is difficult to achieve with nested disjunctions
(inside all **restrictions say). Note that we had no problem with the one-level disjunction in**
dateRange.

A second kind of construct that is difficult to add efficiently and completely is **same-as**.

The reason here is that same-as interacts with all in a way that generates a potentially infinite number of all restrictions; therefore, the implementation of same-as **is best combined**