with that of all**, resulting in a non-tree data structure (Borgida & Patel-Schneider, 1994).**
A speculative way to preserve structural subsumption might be to allow all **to apply to**
chains of a attributes represented by regular expressions. **(In general, the complications of**
implementing same-as are the reason it does not appear in C-classic and **neo-classic**.)
Finally, as mentioned earlier, we do not currently cover role constructors and recursive concept constraints. Furthermore, constructors that require entirely new deductive mechanism (e.g., epistemic reasoning, defaults, forward-chaining rules) will also have difficulty being integrated properly into this framework.

On the positive side, we have considered extensions supporting strings (Borgida, Isbell,
& McGuinness, 1996), and most elaborately, a reconstruction of the clasp **reasoner about**
actions and plans (Borgida, 1992b). To summarize this "success" briefly, clasp **(Devanbu &** Litman, 1996) was a system built on top of classic **for reasoning about actions (which were**
represented in propositional STRIPS-style, having concepts for pre- and post-conditions, as well as add and delete lists); plans were represented by regular expressions of actions, as illustrated below. Our goal was to apply the protodl approach to clasp**, hoping to**
be able to reproduce the original, custom-made implementation discussed by Devanbu and Litman (Devanbu & Litman, 1996). First, we introduced a concept constructor for actions, act(P reC, P ostC, AddC, DeleteC)**, with the expected logical properties expressed as rules**
of inference in the various categories (e.g., if P reC **was incoherent, then the action was also**
incoherent). The implementation then followed immediately.

The more interesting problem was dealing with plans. The constructors single, seq, loop, and altern can be used to build complex plans from actions, as in seq( single(**DIAL**),
loop(single(RING**))). These plans denote** sequences of action instances **(e.g., in the above**
example, a dialing action followed by any number of rings). Although we provided rules of inference for plans too, it turns out that there is no normal form for regular expressions! Instead, in the implementation, Normalize for seq, altern and loop **built a nondeterministic finite automaton, which then had to be made deterministic, and in which**
certain chains of arcs had to be removed (if the post-condition of the action on the incoming edge was inconsistent with the pre-condition of the action on the outgoing edge).

Moreover, the containment algorithm for these finite automata had to take into account the fact that actions on transitions (e.g., MOVE) may represent generalizations of others (e.g., MOVE-FAST). This implementation was achieved in protodl **by introducing a**
"hidden" concept constructor, top-plan-exp**, which enclosed the top plan. It was then**
top-plan-exp::Normalize **that made the automaton deterministic and removed some**
transitions, and top-plan-exp::Subsumes? that implemented the special subsumption algorithm. Moreover, the requirement to implement top-plan-exp::Conjoin**, which was not**
present in the original clasp system, made us realize that without this, clasp **plans could**
not appear in other concepts, because expressions like and(all(p,PLAN1), all**(p,PLAN2))**
could not be normalized. As a result we believe we reconstructed and improved the original clasp **proposal, by characterizing the inferences performed through rules of inference, and**
by allowing plans to be first-class values, which could appear in ordinary roles.