
## 3.5 Relationship To "Concrete Domain" Extensions

Although we shall address general work on extensible KR&R in **the conclusion, there is**
one specific approach involving description logics that deserves closer scrutiny at this stage, while the details of the present work are still fresh.

Baader and Hanschke's proposal (Baader & Hanschke, 1991) for extending DLs with
"concrete domains" allows concepts to consist of arbitrary **predicates involving values from**
some domain other than ordinary objects (i.e., other than elements of ∆I**), as long as**
these values are fillers of attributes **of ordinary objects. For example, suppose the concrete**
domain is that of dates; as above, we have predicates like BEFORE**, corresponding to**
 ; then, if we had two date-valued attributes arrival and departure**, we could define**
the concept BEFORE(arrival,departure)**, denoting ordinary objects (not sets of dates!)**
whose attributes have appropriately related date values.

In order to keep reasoning decidable, this mechanism requires the concrete domain to be "admissible"**: (i) there must be a predicate denoting the universe of all values in that**
concrete domain; (ii) the set of predicates must be closed under negation; and (iii) it must be possible to decide the satisfiability of any finite conjunction of such predicates. It is interesting to note that these requirements match in part our heuristics for new concept constructors: we also argued for the need to add a top concept **to the hierarchy of new values** (and its negation, the bottom of this hierarchy), and for the **need to be able to compute**
the conjunction of descriptions.

The admissibility of a concrete domain ensures that the protodl **approach can implement any such extension as follows: Syntactically, a domain corresponds to a concept**
constructor. Therefore, a concept like BEFORE(arrival,departure) in the domain **DATE**,
would be represented in protodl as DATE('BEFORE',arrival,departure)**. Then, the**
necessary protodl functions are programmed as follows: DATE::Normalize **tests that**
the predication is satisfiable (otherwise signaling IncoherentExn**), and creates a singleton** list containing the predication; DATE::Conjoin **concatenates the list of predications of** its arguments, checking for the consistency of their conjunction; DATE**::Subsumes?(C,D)** creates the conjunction of all the predicates in C, and their negation in D**, and returns true** if the result is unsatisfiable.

Conversely, Baader and Hanschke's approach could well be applied to date ranges, since these are essentially closed under negation. And since it is **offered in the context of the**
tableau theorem-proving technique mentioned in Section 2.4, this continues to have the advantages of elegance and complete reasoning, as long as the concrete domain reasoner is proven complete. In our case, the entire system would have to **be proven complete.**
We believe though that protodl **is somewhat more general, since it allows concrete**
domains to be value of roles, not just attributes (see our earlier discussion of dates as values of roles). Also, there is some advantage to being able to deal **with non-admissible domains** in cases when negation is not absolutely needed, but its addition would cause an increase in computational complexity; for example, adding negation/complement to regular expressions makes the containment problem non-elementary (Stockmeyer, 1974).