BOOK: **objects that are books - a concept declared elsewhere, probably as a primitive;**
at-least(2,authoredBy): objects that are related to at least 2 other objects by the authoredBy role; the concept constructor is at-least **here;**
all(authoredBy, VENUSIAN): objects that are related by the authoredBy role only to objects that are in the concept VENUSIAN; the concept constructor here is all.

The concept VENUSIAN **might itself be defined as a being whose address includes the planet**
value Venus: and(BEING, all(address, fills(planet, Venus)))**. (Note that descriptions**
can be nested.) A more precise introduction to DLs is presented in Section 2.

Description logics reason both about intensional notions such as concepts, and about extensional aspects having to do with individuals that can be ascribed descriptions and participate in specific relationships. DLs have found a variety of applications in areas such as data management (Borgida, 1995), software engineering (Devanbu & Jones, 1997),
configuration management (Wright et al., 1993), as well as general AI.

A particular description language is characterized, among **others, by the choice of term**
constructors in it, and the significant features of DLs are clear, precise semantics and terminating reasoning algorithms for tasks such as determining whether a concept is coherent, or whether it is more general than another one.

A common difficulty faced both by designers and users of knowledge-base management systems (KBMSs) based on DLs (or any other logic, for that matter) is that many applications need to keep information about specialized kinds of **data, including strings, dates,**
pictures, sequences of values of various kinds, etc., and it **is practically impossible to anticipate all of these as part of language design.**
A related problem is that if reasoning is to be complete and efficient, or even decidable, then what can be expressed in the language must be limited. For example, if in Figure 1 we also wanted to say that the authors speak the language in which the book is written, there is a concept constructor already discussed in the literature, called subset-of**, with which**
one could express such a constraint as subset-of**( [writtenIn] [authoredBy,speaks] )**.

Unfortunately, reasoning in a language that supports constructors and, all and **subset-of** is known to be undecidable (Schmidt-Schauss, 1989). This means that the selection of concept constructors in the language is a matter of very careful consideration for the system designer, who is faced with several choices: (a) Select a particular subset of constructors for which a sound and complete reasoning algorithm is known; if the language is sufficiently limited, this procedure is guaranteed to be "fast" (e.g., in polynomial time); otherwise, its worst case complexity is non-polynomial, though in practice the algorithm may behave well. Living with "limited languages" is however not always easy (Doyle & **Patil, 1991). (b) Choose**
a larger set of constructors (possibly one which is even undecidable), and implement an incomplete reasoner; this however requires having to explain to the user which inferences will or will not be made. Both alternatives have different shortcomings, but, from our viewpoint, a significant common problem is that in all cases it is the designer of the DL system who makes these decisions ahead of time**, leaving the user to sort out the consequences later on.**
We propose to attack the above problems by starting with a relatively small, kernel language and system, and then providing facilities to extend it by adding new concept constructors**. Such extensions are not to be undertaken lightly, since they provide opportunities**