
## 4. Processing Of Individuals In Dls: An Introduction

Concept descriptions, as introduced above, are intensional objects, suited for capturing generic information about a domain, such as the ontology of terms. DL-KBMSs must also manage extensional/factual information about individual **objects - the so-called A-box**5.

## 4.1 Inferences Involving Individuals

Normally, one can assert information such as the fact that some object Anni **is known to**
be an instance of a concept CHILD (written as Anni:CHILD**), or that it has some other**
object, Lego as a filler for its hasToys role (written as (Anni,Lego):hasToys**). Based**
on this information, the KBMS can deduce information about the individual's membership in other descriptions (written using −→ ); for example, in this case we know **Anni**
−→ at-least(1,hasToys)**. Because DL-KBMS usually do not make the closed-world assumption, it is also necessary to record when some set of fillers is complete for an individual's**
role. This is done using an (auto-epistemic) assertion like Anni:allFillersKnown(hasToys,{Lego,Barbie})**. As a result of such an assertion, we**
can then deduce that Anni −→ at-most(2,hasToys)**. (Note that we have distinguished**
the three kinds of assertions in A, namely b : C,(b, e) : p, b : allFillersKnown(p, S**), from**
the corresponding judgements that can be deduced in the logic: b −→ C, b −→ fills**(p,e),**
b −→ closedFillers**(p,S).)**
Information about fillers and roles being closed (i.e., all fillers being known) can also be deduced, as in the case of the KB that contains A={Lori:all(hasToys,one-of**(Lego45)),** Lori:at-least(1, hasToys)}, from which we can conclude that Lego45 **is a toy owned by**
Lori (written as Lori −→ fills(hasToys,Lego45**)) and that the complete set of fillers for**
hasToys is { Lego45 } (written as Lori −→ closedFillers(hasToys,{ Lego45 }**)). We**
note that an elegant formalization of these notions has been **obtained by adding an epistemic**
modal constructor K to DLs (Donini et al., 1998). This constructor has a number of **other**
uses, but to shorten the presentation we have not introduced **it here explicitly.**
Formally, we define a knowledge base KB to be a concept knowledge base CKB, extended with a set A of assertions of the form b : C, (b, e) : p and b : allFillersKnown(**p, S**),
where S is some set of individuals. An interpretation I **is said to be a model for** b : C if b I ∈ CI, a model for (b, e) : p if e I ∈ p I(b I), and a model for b : allFillersKnown(p, S**) if**
(e I ∈ p I(b I) ⇐⇒ e ∈ S)
6.

The judgment KB |= b −→ C holds iff for every model I **of KB,** b I ∈ C
I; the judgement KB |= b −→ fills(p, e) holds iff for every model I **of KB, (**b I, eI) ∈ p I**; finally,**
KB |= b −→ closedFillers(p, S) holds iff KB |= b −→ fills(p, bi) for every bi ∈ S**, and** for every other individual e not in S, there is some interpretation I **of KB such that** 6KB |= b −→ fills(p, e**) . Because our concept language may not have negation, and because**
we have the open world assumption, we also need to be able to talk about non-membership in a concept: b 6−→ C; naturally, KB |= b 6−→ C iff for some model I **of KB,** b I 6∈ C
I**. As**
usual, a KB will be called inconsistent **iff it has no models.**