The specification of reasoning about individuals can again be represented by inference rules (Borgida, 1992a). For example, for the constructor all**, we proffer the following three**
rules of inference, which describe the "structural membership/non-membership" rules, as well as a kind of inference called "propagation", where information about some individual b **results in new information being deduced about** another **individual** e:

KB ⊢ b −→ closedFillers(p,S) KB ⊢ bi −→ C KB ⊢ b −→ all(p,C) S = {b1, · · ·, bn}, n ≥ 0 KB ⊢ b −→ fills(p,e) KB ⊢ e 6−→ C KB ⊢ b 6−→ all(p,C) KB ⊢ b −→ all(p,C) KB ⊢ b −→ fills(p,e) KB ⊢ e −→ C
Note that for an inconsistent KB, we can have KB ⊢ b −→ nothing**, or we can deduce**
information from fillers (e.g., KB ⊢ b −→ at-least(3,pets)**) that contradicts information**
asserted or deduced from descriptors (e.g., KB ⊢ b −→ at-most**(2,pets)**).

## 4.2 Dl-Kbms Operations On Individuals

The point of living with the open-world assumption is to allow information to be accumulated incrementally, as in the case of designing some artifact (one of the most successful applications of **classic**).

From the functional point of view, the DL-KBMS therefore supports the following update operations for incrementally adding information about individuals:

| Operation              | Effect                                                                                                   |
|------------------------|----------------------------------------------------------------------------------------------------------|
| assert-member(b, C)    | b : C is added to A                                                                                      |
| assert-fills(b, p, b1) | (b, b1) : p is added to A b:allFillersKnown(p,S) is added to A, where S is                               |
| assert-closed(b, p)    | the set of individuals returned in the current KB by the operation ask-for-fillers(b, p), defined below. |

If as a result of the update, the KB is inconsistent, then the update is rejected and the state of the KB is supposed to remain unchanged.

At any point, the KBMS is able to respond to inquiry operations about relationships involving individuals:

| Question              | Answer type     | Response                                               |
|-----------------------|-----------------|--------------------------------------------------------|
| ask-member?(b, C)     | Boolean         | true iff KB |= b −→ C                                  |
| ask-non-member?(b, C) | Boolean         | true iff KB |= b 6−→ C                                 |
| ask-for-fillers(b, p) | SET(Individual) | { e | KB |= b −→ fills(p, e) }                         |
| ask-closed?(b, p)     | Boolean         | true iff for some set S KB |= b −→ closedFillers(p, S) |

As with concepts, many DL-KBMS pre-compute the b −→ C **judgment, for all individual**
and concept names, by finding the most specific named descriptions to which the individual b provably belongs. Similarly, the DL-KBMS pre-computes and **caches the fillers and closed**