information for each individual's roles. This is done in order to detect inconsistencies at the time of the update, to decrease the amortized cost in case queries are much more frequent than updates, and to support queries of the form "What additional information can you deduce about v?". The utility of such queries has been shown, among others, **in applications**
involving information discovery in software development (Devanbu, 1994).

## 5. Individuals In **Protodl**

Reasoning about individuals The goal of our implementation **is to support efficiently the**
update operations, which are incremental**, so that most of the inferences are precomputed:**
for each individual, we know the least classes it is an instance of, all the fillers it can have for each role, and whether the role is closed or not for that individual. The architecture below describes an extension and rationalization of the individual processing that is usually carried out in normalize-compare DL-KBMS such as classic**. The novelty will be the**
systematic separation of the interaction between various kinds of updates and various kinds of inferences, and the concomitant use of truth-maintenance links.

## 5.1 The Basic Architecture Of Individual Reasoning

In some systems, one can try to reduce individual reasoning to concept reasoning by associating some single, maximally complete description with each individual. However, this is not always possible, as shown by Schaerf (Schaerf, 1994).

Instead, our data structure for every individual includes both a concept description (to be called Descriptor**), which may be an existing class or an unnamed complex description, and** individual role-filler information **recording the specific values assigned so far, and**
whether the role is closed or not. (This information is accessed with built-in functions add filler, put closed, get fillers and is **closed?**.)
In processing an update about some individual b**, we must therefore resort to two**
kinds of reasoning: (i) subsumption/incoherence reasoning involving only the description Descriptor(b**) and other concepts; (ii) reasoning specific to the individual and especially**
its role fillers.

The former kind of reasoning is motivated by general inference rules connecting membership and subsumption (e.g., if b −→ C and C =⇒ D then b −→ D**). Since subsumption**
and its extensibility has been described in the preceding section, henceforth we concentrate on the second aspect of individual reasoning.

To understand the tasks involved, let us illustrate what kinds of reasoning need to be performed whenever any fact is asserted (or inferred) about **an individual** b
- The KB may become inconsistent, because of a conflict between the individual descriptor and the filler information either on b **or some other individual. For example,**
more fillers might be added to a role than permitted by an at-most **restriction. This**
requires the entire update to be rejected. Note that an update may result in several individuals with inconsistent information on them. The system is only required to detect one of them, before rejecting the update.