- The individual b may end up being re-classified. **In a monotonic system, such as the**
present one, this means that the individual may now belong to **some more specialized**
class(es) in the hierarchy.

- New information about the roles of individual b can be inferred. **For example, learning**
that a role is closed allows us to now count its fillers and hence obtain an exact upper bound recordable by **at-most**.

- New assertions can be inferred about other individuals, usually ones related to b via roles. For example, if an all(friends,HAPPY) **description applies to some individual**
x, and now y is asserted to be a friends-filler for x, then we can infer that y **is an**
instance of **HAPPY**.
To support the first task above, protodl might use the function ConsistentW?7**, which**
returns true to indicate that information to be added to an individual is consistent. For the second task, we use function Recognizes?**. For the third and fourth tasks, which** involve individuals other than the one on which the update has occured, we use function InferFrom.

These functions are used to implement the various assert **KBMS operations, as well**
as the ClassifyIndividual function, which is used by protodl **to find the lowest classes**
in the hierarchy to which this individual belongs.

As in the case of concept reasoning, we use the and **constructor to drive the processing,**
and we modularize the implementation so each kind of constructor Q has its own set of functions: Q::Recognizes? , Q::ConsistentW? , Q::InferFrom **. It now becomes more**
important to distinguish constructors, like all and at-most**, that have an associated single** role, in contrast to generic constructors such as one-of **(which has no roles associated) and** same-as **(which has many roles, none of which is special). For the former, so called** branch constructors**, the above functions will have arguments that include not just the individual**
and the normalized representation of Q**-terms, but also the fillers and closed information**
about the role. (This is done to prevent repeated retrieval of these values by each such constructor.) Therefore, the general form of and::Recognizes?, provided in protodl**, is**
and::Recognizes?(b:<Individual>,NC:<NormalizedConcept>)returns <**Bool**>
{ For every Q**(T) in getNonbranchComponents(NC) do**
if not Q::Recognizes?(b,Q**(T)) then return false;**
For every role p in getRestrictedRoles(NC) do
{F:= get **fillers(b,p);**
clsd? := is **closed?(b,p);** For every Q**(T) in getBranchComponents(NC,p)**
{if not Q::Recognizes?(b,Q**(T),F,clsd?)**
then return false};};
return true; }