- all::ConsistentWAsserting?(ind,all(r,vr)) verifies that all r-fillers y of ind are consistent with vr by invoking and**::ConsistentWAsserting?(y,vr)**.

One might also consider variants of Q::Recognizes?**, but, as we shall see, in our case**
these are of limited use since we do not propose to keep information on which parts of the recognition test had succeeded already, and therefore we need to start from the beginning.

## 5.3 Dependency Links

Clearly, the results of function calls, such as Recognizes?, on some individual Bob **might** change after an update to Bob itself. However, the membership of Bob in a class or Bob's consistency may depend on facts asserted about other **individuals in the database. For**
example, if all of Bob's friends are known (i.e., the role friends **is closed), and all but**
one of them was MARRIED, and now that holdout, Larry**, is also asserted or inferred to be**
MARRIED, then Bob itself can be reclassified as an instance of all**(friends,MARRIED)**.

This means that without some special data structure, after every update of some individual an unsophisticated implementation has to reconsider every **other individual in the**
KB.

One alternative, used in loom **(MacGregor, 1986), is to keep track of all questions asked**
about an individual as part of the previous processing ("hits" and "misses"), and if answers to these do not change as a result of the update then no re-processing **is needed. Another**
alternative is to use an elaborate truth-maintenance system (as available in kl-two **(Vilain,**
1985)), for each kind of judgment. In our opinion, both these **approaches might however**
become very expensive in terms of space and often computation time, because they maintain too many details.

We follow an intermediate stance, first suggested by Peter Patel-Schneider for the classic **implementation, which is intended to reduce needless re-testing while incurring relatively less "dependency maintenance" overhead. Essentially, we have a "coarse-grained"**
dependency structure, where one individual e may point to another, b**, if the result of**
a decision about the latter may change as a result of some **(unspecified) additional information being added to the former. For example, in the presence of the definition**
CanineLover .=all(pet,DOG), if Tintin has Fido as a pet filler, and neither Recognizes?(Fido,DOG) nor not ConsistentW?(Fido,DOG) **return true, then we add a link**
of the form: Fido −−−−−−−−−−−−→ RecognizeDependsOnMe Tintin. Thereafter, any change of status of Fido **will**
cause Tintin's classification (with respect to CanineLover**, as well as other pending classes)**
to be re-done. Similarly, we will have −−−−−−−−−−−−→ ConsistentDependsOnMe and −−−−−−−−−→ InferDependsOnMe **links between**
objects.

Note that when following such dependency links back, we do know that only properties of the fillers of some role might have changed, so that once again we could have variants and::RecheckConsistentW? and and::RedoInferFrom, which perform less work by omitting the checks involving constructors that are known not to **be affected by such aspects**
(e.g., at-most **only cares about the count of the fillers, not their properties).**
In order to set dependency links, every function such as Q::Recognizes? **needs to**
keep track of the list of individuals whose modification might change the result of the function. These values must eventually be appropriately linked with dependencies either by the functions themselves or by the calling environment.