
## 5.4 Coordinating The Components

As should be clear from the above examples, the task of the top-level KBMS update operations (assert**s) will include not just invoking the appropriate functions** on the individual being updated, but also setting appropriate dependency links, gathering **into queues other**
objects whose dependency links have been "tickled" by the latest update, and then repeating these operations on the other individuals brought into focus by inferences or dependency links.

An appropriate software architecture for representing this processing seems to be a blackboard model, where we have 5 lists to which functions can post tasks to be carried out:

- Two lists, ToRecheckConsistencyList, ToRedoInferFromList**, for objects that are**
reached from individual x **via a corresponding kind of dependency link as a result of**
a change to x.

- A list, ToPerformUpdateList**, which collects the additional inferences to be made that**
are found by the InferFrom and RedoInferFrom **function calls. For simplicity, these**
are recorded as additional calls to versions of the three kinds of assert **functions.**
- A list, ToReclassifyList**, which receives objects that need to be checked in case**
they can be classified further down the hierarchy; these objects come not just from dependency links but also from any additional assert**s that had been triggered.**
- Finally, a list ToAddDependencyList**, that keeps track of dependency links that need**
to be added to the knowledge base; this list is augmented by the various functions, as mentioned in the previous section.
Because, for example, re-classification may cause new inferences, which may cause reclassification due to some other constructor, there is no linear order in which these lists can be processed. We may therefore have a loop where a "demon" **removes an arbitrary**
object from a list, invokes the required function, and then repeat the process. The only requirement is that dependencies on ToAddDependencyList **be also considered as having** been installed, whenever chasing objects that may have been **affected by an update. Note** that, not surprisingly, it is hard to make any general statements about the termination of the above algorithm skeleton, since the various functions, especially InferFrom**. are free to** do whatever they want, including increasingly longer descriptions..

Several policies can help the performance of the system:
- **In all cases, it is helpful to eliminate duplicates from the lists.**

- **Locality of context may improve performance; therefore grouping together operations**
to be performed on one object is advisable (e.g., gather together all the dependencies from object y on **ToAddDependencyList**).

- If we expect inconsistencies to arise infrequently, then the ToRecheckConsistencyList **can be processed at the end.**