Applying this rule straightforwardly to verify whether some b −→ same-as([f1, · · ·, fn],
[g1, · · ·, gm]) requires one to try all possible ways of dividing up the chain [f1, · · ·, fn**] into**
subchains, and for each, one needs to try to derive the subchain equalities alternately from individual fillers along the chain, or from explicit assertions of same-as **descriptions on**
individuals. In this cases, the implementor, in consultation with the knowledge engineer who is to use the extended system, would make a judgment on the **necessity of implementing**
this more expensive inference. The rules of inference can be **used to describe the deductions** that have been implemented and those that have not.

In order to check consistency, we need to consider the three kinds of updates: assertions, fillers, and closings. When an equality is first asserted of an **individual, we would invoke:**

$\left(\mathfrak{e}1\right)$  $\mathfrak{i}\mathfrak{f}$
* [16] M. C.  
* [10] M. C.  
$$\begin{array}{l}{{\mathrm{tot}\,({\bf p}^{\,\prime}=})}\\ {{\mathrm{hen}}\,\,\,\{}}\\ {{\mathrm{.}}}\end{array}$$
$$\begin{array}{c}{{\mathbf{i}\mathbf{f}}}\\ {{\mathbf{i}\mathbf{f}}}\end{array}$$
  **Acknowledgement**  I would like to thank my supervisor, for his help and guidance. I would like to thank my supervisor, for his help and guidance.  
same-as:: ConsistentWAsserting?(ind, same-as**(chain1,chain2))**
{ **(e1,p') := follow chain1 from ind;**
if not(p'=nil)
then { post dependency e1 −−−−−−−−−−−−→ ConsistentDependsOnMe **ind; return true;**}
# (e2,q') := follow chain2 from ind; if not(q'=nil) then { post dependency e2$\xrightarrow[\text{Consistent}]{}$if e1=e2 then return true else sign; }
then { post dependency e2 −−−−−−−−−−−−→ ConsistentDependsOnMe **ind; return true;**}
if e1=e2 then return true else signal InconsistentExcn; Since the attributes can have at most one value, these attributes get closed automatically when a filler is provided, so there is usually no explicit closing of the role that can affect same-as, and there is no need for same-as**::ConsistentWClosing?**.

Finally, if C includes as a conjunct same-as(chain1,chain2), then and::ConsistentWFilling?(ind,C,p,newfiller) **will have to invoke**

## Same-As::Consistentwfilling?(Ind,Same-As**(Chain1,Chain2),P,Newfiller)** {**If (Member(P,Chain1) Or Member(P,Chain2) )** Then Same-As:Consistentwasserting?(Ind,Same-As**(Chain1,Chain2))**}

Equalities can lead to inferences when one of the chains is completely known, and all values but that of the last attribute on the second chain are known, as illustrated by the following example:

$$\{\ a:\mathbf{same\mbox{-}as}([q]\,,\ [p,r]),\ \ (a,e):q,\ \ (a,b):p\ \}\ \models\ b\longrightarrow\mathbf{fills}(r,e)$$

This inference requires us to set up −−−−−−−−−→ InferDependsOnMe **links to watch for cases when we have**
sufficient information to make the inference.

We point out that same-as **presents one example of a situation where a performance**
penalty is paid for separating out consistency checking, recognition and inference: each of these functions attempts to traverse the individuals along **the two chains of the equality in** an effort to reach the ends. This price is negligible if there are relatively few individuals with same-as conditions attached, or if the chains are usually only one or **two attributes long, as** is the case for the application of same-as **illustrated earlier. Otherwise, we can introduce**