caching to speed up the code: associate with every equality and individual b **two pairs (**e1,r1)
and (e2,r2) representing the ends ei **reached on each chain, and the remainder of the chains**
ri left to be traversed. (So if the chain is completely known, r = nil**.) A final alternative is**
to add the code for same-as::InferFrom into same-as::ConsistentW? **function, so the**
latter performs all the deductions involving same-as**. The disadvantage of this approach,**
as of many optimizations, is the loss of modularity.

Finally, we mention that other extensions of reasoning at the individual level that we have considered include "database aggregate functions" like sum (e.g., sum**([departments**
budget], totalBudget) can be used to model that totalBudget **is the sum of the values**
for budget **fillers for all department fillers); and epistemic constructors that allow one to**
query the state of knowledge (Donini et al., 1998) (e.g., known-all(friends, known-at-most(1,pets)) **recognizes individuals all of whose** known friend **fillers have at most**
one pet recorded in the KB, without having to have the roles be **closed).**

## 6. Conclusions

We began from the hypothesis that no "perfect" DL will ever be **built, because of the**
need for application-specific reasoning, and potential incompleteness of reasoning due to the expressiveness-(tractability/decidability) trade-off. We argued that some of these issues are best attacked on a per-application basis. To resolve this problem, we proposed the use of an extensible **DL-KBMS, where one tries to go as far as possible with an initial set of wellunderstood concept constructors, and then, when encountering unsolvable expressiveness**
problems (Doyle & Patil, 1991), add new concept constructors to overcome them.

We have also pointed out the limitations of this approach, which include not being conducive to including new forms of reasoning such as abduction, contexts, etc., and having difficulties with complete inferences for useful concept constructors that require reasoning by contradiction, and are best handled in the alternative DL **reasoning paradigm - tableaux.**

## 6.1 Implementation Status

Prototype implementations of aspects of both concept and individual reasoning in **protodl**
have been carried out at Rutgers. However, experience with all fielded systems indicates that there is an order of magnitude more work to be done in making a system usable by others than their developers. For this reason, our goal is to add the results of the **protodl**
research to an existing DL-reasoner. In fact, several ideas **have been transfered, with the**
collaboration of Charles Isbell, to the newest version of the classic **system released by**
AT&T Research. In particular, classic **supports** test-defined **concepts - ones which allow**
the recognition of individuals through the use of an arbitrary LISP function. (This function can be seen as the combination of the Recognizes? and ConsistentW? **functions discussed**
in the present paper.) In the newest version of classic**, one can simulate the addition of**
new concept constructors by using them after the keyword test-c**. For example, the concept**
all(vacation,dateRange(1996/6/1,1996/8/31)) **would be represented as**
(test-concept **dateRange vacation '( (1996 6 1) (1996 8 31)) )**