Although not all aspects of the protodl **system have been implemented, the current**
extensions (Borgida et al., 1996) allow significant subsumption reasoning to be done for test extensions, and thus provide classic **with the bases for extensible reasoning.**

## 6.2 Related Work

In order to incorporate new concept constructors into a reasoner, we need to extend the implementation. One approach to this would be to offer some form of "declarative description" of the inferences to be performed, and then have a meta-interpreter which executes them. In fact, such approaches have been tried in the past for other kinds of representation formalisms (Greiner & Lenat, 1980; Genesereth, 1983). Except for cycl **(Lenat &**
Guha, 1990), which allows the addition of new forms of inference rule schemas in First Order Predicate Calculus, we see little evidence that such a **meta-interpreter has a chance**
of being nearly as efficient as custom-built implementations, so we have opted for a different approach.

Joshua (Rowley, Shrobe, & Cassels, 1986) is also an effort at providing extensible reasoning, which allows the user (knowledge system engineer) the ability to change at compile-time the implementation of any or all of the elements of the protocol of inference**, which describes**
the reasoning of the system. Joshua is close in spirit to our work in the sense that it tries to maintain a uniform "knowledge level" view of the system, and **because it identifies, in the** "protocol of inference", the specific aspects of the system that can be customized through
(re)programming of Lisp functions. Our efforts differ from Joshua in that we are interested in DLs (Joshua's protocol was concerned mostly with rule triggering and truth maintenance), we wish to support incrementing the syntax of the knowledge-level interface, and we also care about the semantics of the extension.

Gaines has also advocated the utility of a declarative specification and of a clean, extensible modularization for a DL-reasoner (Gaines, 1993). At the concept level, one difference between our approaches seems to be that protodl **only assumes that the concepts will**
form an upper-semilattice (the and constructor is built-in), so that a wider variety of inferences can be implemented for new constructors. At the individual-reasoning level, **protodl**
starts from a much more restricted basis, and uses its extensibility to deal with such aspects as "propagations" (e.g., our example dealing with same-as **reasoning appears to be built-in**
in KRSn). On the other hand, KRSn has built-in support for rules and exceptions to them, which are an important component for any knowledge-based environment.

Finally, it has been suggested that the tableau-based approach, such as that of **crack**,
is essentially extensible through the addition of new "completion" rules (Bresciani et al.,
1995), which are traditionally used to build a model of a certain knowledge base, or prove its inconsistency. These tableau completion rules can also implement incomplete reasoners by using only a subset of the inferences. As with concrete domain extensions (Section 3.5), the advantages of extensible tableau techniques lie in a clean formalism that can lead to complete reasoning, while the disadvantages involve language extensions that do not have negation
(e.g., clasp **– see Section 3.4), and, for the moment, the lack of experience with large**
A-boxes and incremental updates. One of the most exciting (though very likely difficult)
future prospects is combining the two implementation paradigms, and their extensibility features.