
## 6.3 Summary

We have advocated an approach to extensible DL reasoning and **implementation, for the** normalize-compare paradigm, which has two components: a declarative specification and a modularized implementation framework. The specification **is offered using rules of**
inference in the "natural semantics" style, and a heuristic **methodology suggests various**
categories of rules to be looked for. These rules often correlate well with the implementations of the various functions, but protodl **offers the implementor the opportunity to**
use a very different implementation. The later is needed in the case of constructors whose argument is for example some regular expression - as in the case of plans or strings, when the implementation needs to use some kind of finite automaton **representation, since regular** expressions have no "normal form".

We have modularized the software architecture of protodl **reasoner, so that for every**
new concept constructor added to the language, there is a well-defined set of functions that need to be implemented. These, in turn, sometime have detailed skeletons composed of other, smaller functions, which we have abstracted after analyzing a variety of implementations. The invocation of these functions is organized by the built-in functions of **protodl**,
usually involving the constructor and**. We have paid particular attention to supporting**
efficient implementations, by offering the implementor quite **a lot of freedom within the** confines of our major functions. For individual reasoning, this is the first paper to consider the need to be efficient in the face of incremental updates of DL-KBMSs, which live with the open-world assumption, and which use concept descriptions to infer new properties, rather than just verify the correctness of individual facts. Our solutions involved proposing function variants based on the form of the update, and the use **of various kinds of associated** dependency links.

The major open areas involve adding to this framework role constructors, epistemic rules (like those in classic**, characterized by Donini et al (Donini et al., 1998)), the ability**
to express at least simple recursive declarations for primitive concepts (e.g., "the parents of a person are persons"), and connections with the tableau-based implementations for DL
reasoning.

## Acknowledgements

I am very grateful to Ron Brachman, who, among others, joined me in the initial explorations of the protodl **idea; to Daniel Kudenko, who implemented a significant part of**
the individual reasoning; to Charles Isbell, who implemented the extensibility features of classic **2.3; and to Peter Patel-Schneider, for years of discussion on the subtleties of the**
classic language and implementation. Extremely useful comments on **the presentation**
and organization were provided by Peter Clark and the anonymous reviewers.

This work was supported in part by NSF grants IRI-91-19310 and IRI-9619979.

## Appendix A. A Generic Conjunction Function.

The following pseudo-code for Q::Conjoin **shows how one can construct this function from** several, smaller functions.