/* Conjoin the new term Q(T) onto the already-normalized description This*/
Q::Conjoin(T:<NormalizedQ-term>,This:<**NormalizedConcept**>){
old := get Q**(This) /*** find the part of This dealing with constructor Q*/
if not(old=nil)
then if Q**::SubsumesSame?(T,old)**
then signal RedundantExn; T := Q**::ConjoinToSame(T,old); /*** combine T with old*/
if Q**::SubsumesDifferent?(T,This) /*** T is implied by other constructors */ then signal RedundantExn; T:= Q**::ConjoinToDifferent(T,This) /*** obtain a possibly stronger T*/
if (type(T) 6= Q**) /*** the stronger description might use another constructor*/
then {**post T to ImplicationsToDoList; /*** for later processing*/
return; }
Q**::ConsistentWithDifferent?(T,This) /*** Check if T is coherent with the rest of This; if not, an exception is raised.*/
put Q**(T,This) /*** add the description to the normalized descriptor This*/
Q**::FindOtherImplications(T,This,ImplicationsToDoList)**
/* add any additional constructors implied by T and This */
Figure 3: Pseudo-code of a generic conjunction function.

Before we consider the individual functions introduced above, we remark that if the constructor Q implies terms built with other constructors (i.e., it adds entries to the ImplicationsToDoList), then the and::Conjoin **function needs to be augmented with a loop at**
the end, which conjoins to ontoNC all the normalized terms on the **ImplicationsToDoList**:
while notEmpty(ImplicationsToDoList)
{ **another := removeAnElement(ImplicationsToDoList);**
suppose **type(another)=**Q;
Q**::conjoin(another,ontoNC)**
Note that this processing may itself add new entries to the ImplicationsToDoList**. In** the case that there are many additions being done to the ImplicationsToDoList, a useful optimization might be to test for and remove redundancies from ImplicationsToDoList. If there are very few constructors making additions, a different optimization might be applied: add the above code only to the end of the corresponding constructor's Conjoin **program.**
The following is the intended purpose of the component functions used in the Q::Conjoin function in Figure 3. Note that for any particular constructor (e.g., all),
not every such function needs to be implemented. When using a **good optimizing compiler,**
default programs for these could be provided, which return constant values. Otherwise, Conjoin **itself should be edited.**