- Q**::Universal?(T)**: Is T equivalent to the top of the hierarchy for that set of values? For example, at-least::Universal? **returns true when processing**
at-least(0,players)**. This is used to eliminate unnecessary constructs from the**
normal form.

- Q**::Incoherent?(T)**: Is T incoherent by itself ?

For example, some(players ,nothing) is incoherent since nothing **has no instances.**
- Q**::IncoherentWithDifferent(T,This)**: Is there an inconsistency if we consider conjoining with other constructors? For example, when Q=at-least**, conjoining**
at-least(3,players) to a concept already containing at-most(1,players) **would**
lead to inconsistency.

- Q**::SubsumesSame?(T,oldTs)**: Is T implied by the Q-constructed terms already seen in oldTs? **This is basically the "structural subsumption" part. For example, if**
Q=at-least, and oldTs has at-least(4,players), then at-least(3,players) **is redundant**
- Q**::SubsumesDifferent?(T,This)**: Is T implied by other constructors? **For example,**
at-least(1,players) is implied by some**(players, OLD)**.

- Q**::ConjoinToSame(T,OldTs)**: Merge T with any preceding terms built with K. For example, when we combine all(players,GENTLEMAN) with all**(players,SCHOLAR)**,
we obtain all(players,and**(GENTLEMAN, SCHOLAR))**.

- Q**::ConjoinToDifferent(T,This)**: Produce a stronger T by using information from other constructors. For example, if we are processing some(player, TALL)**,then if**
the concept This already has all(player,OLD), then some**::ConjoinToDifferent**
returns the description of some(players,and**(TALL,OLD))**.

- Q**::FindOtherImplications(T,This,ImplicationsToDoList)**: Add constructors which are implied because of Q(T), possibly in conjunction with the rest of the concept, This. For example, when adding all(players,TALL) **to a**
concept with at-least(3,players), all::FindOtherImplications **would add**
some(players,TALL) to the list of constructors to be conjoined to **This**.

## References

Baader, F. (1996). A formal definition for the expressive power of terminological knowledge representation languages. J. of Logic and Computation, 6**, 33–54.**
Baader, F., & Hanschke, P. (1991). A scheme for integrating concrete domains into concept languages. In Proceedings of IJCAI'91.

Baader, F., Hollunder, B., Nebel, B., Profitlich, H.-J., & Franconi, E. (1994). An empirical analysis of optimization techniques for terminological representation systems - or -
making kris **get a move on.** Applied Intelligence, 4**, 109–132.**