the "natural semantics" style (Borgida, 1992a), would indicate, among others, that greater bounds on the number of role fillers for role p **lead to more specialized concepts:**
m ≥ n at-least(m, p) =⇒ at-least(**n, p**)
This rule can be paraphrased as "IF one can prove m ≥ n THEN one can write as the next line of a proof that at-least(m, p) =⇒ at-least(n, p)." **Such a rule allows us to prove that**
at-least(2,authoredBy) =⇒ at-least**(1,authoredBy)**.

As usual, it is possible (and desirable) to demonstrate that **the rules of inference are**
sound and complete with respect to the denotational semantics. Rules of inference are useful in characterizing reasoners that are incomplete with respect to the standard denotational semantics, by describing either the inferences performed, **or the ones missing. Also, as** we shall argue below, rules of inference can form a good starting point for developing implementations.

## 2.3 Dl Concept Kbms

A concept knowledge base CKB (also known as a T-box) records constraints on concept names, including definitions (such as the concept VENUSIAN **mentioned in our examples) and** necessary conditions for primitive concepts (e.g., a BOOK **would be required to have at least** one author). In some DLs it is possible to state general subsumption constraints between arbitrary descriptions, but this will not be permitted in this paper.

Formally, CKB is a tuple (R, F, C, O, N , D) where R, F, C, O **are respectively the sets**
of role, attribute, concept and individual object identifiers declared. Concept names are either primitive/atomic concept names, PN**, which have associated a necessary condition**
PN ≤˙ C in the set N **of necessary conditions; or** defined concept names, DN**, which have**
associated a definition DN .= C in the set D of definitions. An interpretation I **is a model**
of PN ≤˙ C iff PNI ⊆ CI, and is a model of DN .= C iff DNI = CI**. An interpretation is**
a model of CKB if it is a model of all conditions in N and D.

C is said to subsume D **in the presence of a knowledge base CKB (written CKB**
|= C =⇒ D**), iff** C
I ⊆ DIfor all models I **of CKB.**
In this paper we are restricting ourselves to non-recursive knowledge bases, where definitions and necessary conditions are given at the same time **as the name is declared, and**
they can only involve previously declared identifiers.

A DL-based knowledge base management system **supports certain update operations,**
which affect the CKB (R, F, C, O, N , D**) as follows:**

| Operation                       | Effect                             |           |
|---------------------------------|------------------------------------|-----------|
| declare-primitive-role(p)       | p is added to R                    |           |
| declare-primitive-attribute(f)  | f is added to F                    |           |
| declare-individual(b)           | b is added to O                    |           |
| declare-primitive-concept(PN,D) | PN is added to C, and PN ≤˙ D to N |           |
| declare-defined-concept(CN,D)   | CN is added to C, and CN           | .= D to D |

In return, we expect the KBMS to respond to inquiries, which include retrieving the declarations entered and at least the following operations: