all(pet,nothing) and at-most(0,pet) are equivalent (subsume each other), in a normal form both would appear, so that subsumption comparison with all(pet,DOG) **would**
only require looking at all(pet,nothing), while comparison with at-most(3,pet) **would**
locate at-most**(0,pet)**.

The present work was carried out over a period of several years within this "normalizecompare" paradigm. The original reasons for this choice included the following features, which were only available for this paradigm: having a sizable user base; supporting additional KBMS operations, such as least common subsumer, pattern matching, explanation; reasoning with large knowledge bases of individuals, and especially doing so incrementally in an environment where one needs the "logical completion" of an individual.

We remark that the tableau technology has recently become competitive on sizable knowledge bases of concepts. The promise of provably complete and effective reasoners for expressive languages is very enticing, and therefore the study of extensibility in tableaux approaches (Baader & Hanschke, 1991; Bresciani et al., 1995) is of great interest.

## 3. Concept Reasoning In **Protodl**

Our approach to extensible KBMSs is based on the idea that in a **case when the current**
KBMS does not meet the users' representation and reasoning needs, one can extend it by adding one or more new description constructors - what would be considered logical connectives.

Although this approach is clearly restrictive, it has the advantage of being very specific and directed; it allows us to develop an implementation architecture and accompanying methodology to support the process of extension. The approach is also supported by empirical evidence from the use of the classic **system in many applications: the test-defined**
concepts of classic have been crucial in escaping the expressive limitations of **the basic**
language, and each such test function acts essentially as a new concept constructor2.

## 3.1 The Modularized Implementation Architecture

As previously described, the concept reasoning services of **our DL-KBMS are delivered by** operations which rely on the =⇒ relationship, to be computed by the function **Subsumes?**. In our implementation paradigm, this function takes as arguments two normalized concepts.

Hence we need some way to take input and convert it into normalized concepts. This means parsing the concept (function Parse) and normalizing it (function **Normalize**).

Because of the uniform prefix nature of DL syntax, parsing is easily performed by recursive descent with a single token look-ahead; so we associate **with every concept constructor**
Q, a function Q**::Parse**.

After examining earlier implementations and applications, a key decision underlying the protodl **implementation is that a normalized concept is viewed as the** conjunction **of a**
collection of component concepts, which are either concept **identifiers or are normalized**
terms built with concept constructors Q other than and**. Therefore, it is possible to view**
a normalized concept as a data abstraction that encapsulates the way in which the various