components are stored and accessed thru a set of functions put Q(value) and get Q() —
one for each concept constructor Q. For example, the put one-of **operation stores a set of**
individuals S, while get one-of returns this set3**. On the other hand, for the constructor**
fills, the (normalized) value stored is a set of terms of type <Role × **SET(Individual)**>,
since for each role, we need to store the set of current fillers. For constructors such as fills, which are associated with a single role, we overload the put and get **functions so**
they accept a separate role argument, allowing us to access each value independently (e.g.,
get fills(p:<Role>) returns <SET(Individual)>**). In fact, for such constructors it is**
more efficient to group them by the role identifier, but to simplify the exposition we shall not pursue this distinction in the rest of this section.

As mentioned earlier, the ideal normalized concept would have the property that subsumption could be determined by comparing, using Q::Subsumes?**, only components built**
with the same constructor. In other words, Subsumes? **would have the pseudo-code**
Subsumes?(hiNC, lowNC: <NormalizedConcept>) returns <**Bool**>
;; structural subsumption {For every Q**(T) in getComponents(hiNC) do**
{ lowComponent := get Q**(lowNC);**
if not Q**::Subsumes?(T,lowComponent)**
return false; }
return true; }
As we shall see in Section 3.3, this is too restrictive however, so we will pass as parameter the entire normalized lower concept, lowNC, rather than just the lowComponent**. Therefore,**
for every constructor Q **we expect a function**
Q::Subsumes?(<NormalizedQ-term>,<**NormalizedConcept**>) .

In order to normalize a concept, we will normalize each component separately, and then combine them. Since a normalized concept represents a conjunction, the combinator function will be named Conjoin**. Here are then the remaining functions that are provided ahead**
of time by the core implementation:
Normalize(pC : <ParsedConcept> ) returns <**NormalizedConcept**>
throws IncoherentExn;
/* Start ND to be a data structure having no constraints - i.e.like **thing** */
ND := copy of NormalForm**thing**;
{ /* Normalize each component and conjoin it onto ND */
For every Q**(T) in pC do** {
T norm := Q**::Normalize(T);** Q::Conjoin(T **norm,ND);** }
/* Replace concept ids by normalized form (saved by **declare** ) */
For every concept identifier N in pC do {
N norm := **look up normalized form of** N; Conjoin(N **norm,ND);** }