will evaluate to the same value if P(x ≡ x
′
**) is unknown or if** P(x ≡ x
′
**) = 0.**
Therefore, our algorithm does not need to store equivalences of value 0 at all.

Our implementation thresholds the probabilities and assumes every value below θ **to be zero. This greatly reduces the number of equivalences that the**
algorithm needs to store. Furthermore, we limit the number of pairs that are evaluated in Equations (9) and (12) to 10, **000. For each computation, our algorithm considers only the equalities of the previous maximal assignment and**
ignores all other equalities. This reduces the runtime by an **order of magnitude**
without affecting much the relation inclusion assessment. We stress that all these optimizations have for purpose to decrease the running time of the algorithm *without significantly affecting the outcome of the computation***. We have**
validated in our experiments that it is indeed the case.

Our implementation is in Java, using the Java Tools developed for [27] and Berkeley DB. We used the Jena framework to load and convert the ontologies. The algorithm turns out to be heavily IO-bound. Therefore, we used a solid-state drive (SSD) with high read bandwidth to store the ontologies. This brought the computation time down from the order of days to the order of hours on very large ontologies. We considered parallelizing the algorithm and running it on a cluster, but it turned out to be unnecessary.

## 5.3 Literal Equivalence

The probability that two literals are equal is known a priori **and will not change.**
Therefore, such probabilities can be set upfront (*clamped***), for example as follows:**

- The probability that two numeric values of the same dimension are equal can be a function of their proportional difference.

- The probability that two strings are equal can be inverse proportional to their edit distance.

- For other identifiers (social security numbers, etc.), the **probability of**
equivalence can be a function that is robust to common misspellings. The checksum computations that are often defined for such identifiers can give a hint as to which misspellings are common.

- By default, the probability of two literals being equal should be 0.
These functions can be designed depending on the application or on the specific ontologies. They can, e.g., take into account unit conversions (e.g., between Kelvin and Celcius). They could also perform datatype conversions (e.g., between *xsd:string* and *xsd:anyURI***) if necessary. The probabilities can then be**
plugged into Equation (10).

For our implementation, we chose a particularly simple equality function. We normalize numeric values by removing all data type or dimension information.

Then we set the probability P(x ≡ y) to 1 if x and y **are identical literals, to 0**
otherwise. The goal of this work is to show that even with such **a simple, domainagnostic, similarity comparison between literals, our probabilistic model is able**
to align ontologies with high precision; obviously, precision could be raised even higher by implementing more elaborate literal similarity functions.