
## 5.4 Parameters

Our implementation uses the following parameters:

- The initial value θ **for the equivalence of relations in the very first step of**
the algorithm. We show in the experiments that the choice of θ **does not**
affect the results.

- Similarity functions for literals. These are application-dependent. However, we show that even with the simple identity function, the algorithm performs well.
Therefore, we believe we can claim that our model has no dataset-dependent tuning parameters. Our algorithm can be (and in fact, was) run on all datasets without any dataset specific settings. This contrasts paris **with other algorithms, which are often heavily dependent on parameters that have to be tuned**
for each particular application or dataset. Traditional schema alignment algorithms, for example, usually use heuristics on the names of classes and relations, whose tuning requires expertise (e.g., [20]). A major goal of the present work was to base the algorithm on probabilities and make it as independent as possible from the tuning of parameters. We are happy to report that this works beautifully. In order to improve results further, one can use smarter similarity functions, as discussed in Section 5.3.

## 6 Experiments 6.1 Setup

All experiments were run on a quad-core PC with 12 GB of RAM, running a 64bit version of Linux; all data was stored on a fast solid-state drive (SSD), with a peak random access bandwidth of approximately 50 MB/s (to be compared with a typical random access bandwidth of 1 MB/s for a magnetic hard drive).

Our experiments always compute relation, class, and instance equivalences between two given ontologies. Our algorithm was run until convergence (i.e., until less than 1 % of the entities changed their maximal assignment). We evaluate the instance equalities by comparing the computed final maximal assignment to a gold standard, using the standard metrics of precision, recall, and F-measure. For instances, we considered only the assignment with the maximal score. For relation assignments, we performed a manual evaluation. Since paris **computes**
sub-relations, we evaluated the assignments in each direction. Class alignments were also evaluated manually. For all evaluations, we ignored the probability score that paris **assigned, except when noted.**

## 6.2 Benchmark Test

To be comparable to [16, 20, 23, 25], we report results on the benchmark provided by the 2010 edition of the ontology alignment evaluation initiative
(OAEI) [9]. We ran experiments on two datasets, each of which **consists of**
two ontologies.10 **For each dataset, the OAEI provides a gold standard list of**
10We could not run on the third dataset, because it violates our **assumption of nonequivalence within one ontology.**