
| Instances   | Classes   | Relations   |       |       |       |      |       |       |       |      |       |       |       |
|-------------|-----------|-------------|-------|-------|-------|------|-------|-------|-------|------|-------|-------|-------|
| Dataset     | System    | Gold        | Prec  | Rec   | F     | Gold | Prec  | Rec   | F     | Gold | Prec  | Rec   | F     |
| Person      | paris     | 500         | 100 % | 100 % | 100 % | 4    | 100 % | 100 % | 100 % | 20   | 100 % | 100 % | 100 % |
| ObjCoref    | 100 %     | 100 %       | 100 % | -     | -     | -    | -     | -     | -     |      |       |       |       |
| Rest.       | paris     | 112         | 95 %  | 88 %  | 91 %  | 4    | 100 % | 100 % | 100 % | 12   | 100 % | 66 %  | 88 %  |
| ObjCoref    | N/A       | N/A         | 90 %  | -     | -     | -    | -     | -     | -     |      |       |       |       |

Table 1: Results (precision, recall, F-measure) of instance, class, and relation alignment on OAEI datasets, compared with ObjectCoref **[16]. The "Gold"**
columns indicate the number of equivalences in the gold standard.

instances of the first ontology that are equivalent to instances of the second ontology. The relations and classes are identical in the first and second ontology. To make the task more challenging for paris**, we artificially renamed the**
relations and classes in the first ontology, so that the sets of instances, classes, and relations used in the first ontology are disjoint from the **ones used in the** second ontology.

For the person dataset, paris **converged after just 2 iterations and 2 minutes.**
For the restaurants, paris **took 3 iterations and 6 seconds. Table 1 shows our**
results.11 **We achieve near-perfect precision and recall, with the exception of recall in the second dataset. As reported in [16], all other approaches [20, 23, 25]**
remain below 80 % of F-measure for the second dataset, while only ObjectCoref [16] achieves an F-measure of 90 %. We achieve an F-measure of **91 %.**
We are very satisfied with this result, because unlike ObjectCoref, paris **does**
not require any training data. It should be further noted that, unlike all other approaches, paris **did not even know that the relations and classes were identical, but discovered the class and relation equivalences by herself in addition to**
the instance equivalences.

## 6.3 Design Alternatives

To measure the influence of θ **on our algorithm, we ran** paris with θ = 0.001, 0.01, 0.05, 0.1, 0.2 on the restaurant dataset. A larger θ **causes larger probability scores in the first**
iteration. However, the sub-relationship scores turn out to be the same, no matter what value θ **had. Therefore, the final probability scores are the same,** independently of θ**. In a second experiment, we allowed the algorithm to take**
into account all probabilities from the previous iteration **(and not just those**
of the maximal assignment). This changed the results only marginally (by one correctly matched entity), because the first iteration already has a very good precision. In a third experiment, we allowed the algorithm to take into account negative evidence (i.e., we used Equation (11) instead of Equation (10)). This made paris give up all matches between restaurants. The reason for this **behavior turned out to be that most entities have slightly different attribute values**
(e.g., a phone number "213/467-1108" instead of "213-467-1108"). Therefore, we plugged in a different string equality measure. Our new measure normalizes two strings by removing all non-alphanumeric characters and lowercasing them.

Then, the measure returns 1 if the strings are equal and 0 otherwise. This increased precision to 100 %, but decreased recall to 70 %. Our experience with 11**Classes and relations accumulated for both directions. Values for** ObjCoref **as reported**
in [16]. Precision and recall are not reported in [16]. ObjCoref **cannot match classes or**
relations.