
## 1 Introduction

Motivation. An ontology is a formal collection of world knowledge. In this paper, we use the word *ontology* **in a very general sense, to mean both the schema**
(classes and relations), and the instances with their assertions. In recent years, the success of Wikipedia and algorithmic advances in information extraction have facilitated the automated construction of large general-purpose ontologies. Notable endeavors of this kind include DBpedia **[1],** KnowItAll **[8],**
WikiTaxonomy **[24], and** YAGO **[28], as well as commercial services such as**
freebase.com, trueknowledge.com, and wolframalpha.com. **These ontologies are**
accompanied by a growing number of knowledge bases1**in a wide variety of** domains including: music2, movies3, geographical data4, publications5**, medical**
and biological data6**, or government data**7.

Many of these ontologies contain complementing data. For instance, a general ontology may know who discovered a certain enzyme, whereas a biological database may know its function and properties. However, since the ontologies generally use different terms (identifiers) for an entity, their information cannot be easily brought together. In this respect, the ontologies **by themselves can** be seen as isolated islands of knowledge. The goal of the Semantic Web vision is to interlink them, thereby creating one large body of universal ontological knowledge [3, 4]. This goal may be seen as a much scaled-up version of record linking, with challenges coming from different dimensions:
- unlike in record linkage, both instances and schemas should be reconciled;

- the semantics of the ontologies have to be respected;
- the ontologies are typically quite large and complex. Moreover, we are interested in performing the alignment in a fully automatic **manner, and**
avoid tedious tuning or parameter settings.
A number of recent research have investigated this problem. **There have been**
many works on entity resolution (i.e., considering the A-Box only) [10, 23, 25, 26, 29, 15, 16]. In another direction, much research has focused **on schema alignment**
(i.e., considering the T-Box only) [12, 19, 2, 18, 32]. However, in recent years, the landscape of ontologies has changed dramatically. Today's ontologies often contain both a rich schema and, at the same time, a huge number **of instances,**
with dozens of millions of assertions about them. To fully harvest the mine of knowledge they provide, their alignment has to be built on cross-fertilizing the alignments of both instances and schemas.

In this paper, we propose a new, holistic algorithm for aligning ontologies.

Our approach links not just related entity or relationship instances, but also related classes and relations, thereby capturing the fruitful interplay between schema and instance matching. Our final aim is to discover and **link identical**
1http://www.w3.org/wiki/DataSetRDFDumps 2http://musicbrainz.org/ 3http://www.imdb.com/
4http://www.geonames.org/
5http://www.informatik.uni-trier.de/~ley/db 6http://www.uniprot.org/ 7http://www.govtrack.us/, http://source.data.gov.uk/data/