if ∀x, y : r(*x, y*) ⇔ r
−1(*y, x***). We assume that the ontology contains all inverse**
relations and their corresponding statements. Note that this results in allowing the first argument of a statement to be a literal, a minor digression from the standard.

An RDFS ontology distinguishes between classes and instances. A class is a resource that represents a set of objects, such as, e.g., the class of all singers, the class of all cities or the class of all books. A resource that is a member of a class is called an *instance* of that class. We assume that the ontology partitions the resources into classes and instances.9 The *rdf:type* **relation connects**
an instance to a class. For example, we can say that the resource *Elvis* **is a**
member of the class of singers: *rdf:type(Elvis, singer)***. A more specific class**
c can be specified as a *subclass* of a more general class d **using the statement** rdfs:subclassOf(c,d). This means that, by inference, all instances of c **are also**
instances of d. Likewise, a relation r can be made a sub-relation of a relation s by the statement *rdfs:subpropertyOf(r,s)***. This means that, by inference**
again, ∀x, y : r(x, y) ⇒ s(*x, y***). We assume that all such inferences have been** established and that the ontologies are available in their *deductive closure***, i.e.,**
all statements implied by the subclass and sub-property statements have been added to the ontology.

Equivalence. In RDFS, the sets P, R, and L **are global. That means that some** resources, literals, and relations may be *identical* **across different ontologies. For**
example, two ontologies may contain the resource *London***, therefore share that** resource. (In practice, *London* **is a URI, which makes it easy for two ontologies**
to use exactly the same identifier.) The semantics of RDFS enforces that these two occurrences of the identifier refer to the same real-world object (the city of London). The same applies to relations or literals that are shared across ontologies. Conversely, two different resources can refer to the same real-world object. For example, *London* and *Londres* **can both refer to the city of London.** Such resources are called *equivalent*. We write Londres ≡ *London*.

The same observation applies not just to instances, but also **to classes and**
relations. Two ontologies can talk about an identical class **or relation. They can** also use different resources, but refer to the very same real-world concepts. For example, one ontology can use the relation *wasBornIn* **whereas another ontology** can use the relation *birthPlace***. An important goal of our approach is to find** out that wasBornIn ≡ *birthPlace*.

In this paper, we make the following assumption: **a given ontology does not**
contain equivalent resources. **That is, if an ontology contains two instances** x and x
′
**, then we assume** x 6≡ x
′
**. We assume the same for relations and classes.**
This is a reasonable assumption, because most ontologies are either manually designed [21, 22], or generated from a database (such as the datasets mentioned in the introduction), or designed with avoiding equivalent **resources in mind [28].** If the ontology does contain equivalent resources, then our **approach will still**
work. It will just not discover the equivalent resources within one ontology.

Functions. A relation r is a *function* **if, for a given first argument, there is** only one second argument. For example, the relation *wasBornIn* **is a function,** because one person is born in exactly one place. A relation is an *inverse function* 9**RDFS allows classes to be instances of other classes, but in practice, this case is rare.**