# Complexity Of And Algorithms For Borda Manipulation

Jessica Davies University of Toronto Toronto, Canada jdavies@cs.toronto.edu George Katsirelos LRI, Universite Paris Sud 11 ´
Paris, France gkatsi@gmail.com Nina Narodytska NICTA and UNSW
Sydney, Australia ninan@cse.unsw.edu.au Toby Walsh NICTA and UNSW
Sydney, Australia toby.walsh@nicta.com.au

## Abstract

We prove that it is NP-hard for a coalition of two manipulators to compute how to manipulate the Borda voting rule.

This resolves one of the last open problems in the computational complexity of manipulating common voting rules. Because of this NP-hardness, we treat computing a manipulation as an approximation problem where we try to minimize the number of manipulators. Based on ideas from bin packing and multiprocessor scheduling, we propose two new approximation methods to compute manipulations of the Borda rule. Experiments show that these methods significantly outperform the previous best known approximation method. We are able to find optimal manipulations in almost all the randomly generated elections tested. Our results suggest that, whilst computing a manipulation of the Borda rule by a coalition is NP-hard, computational complexity may provide only a weak barrier against manipulation in practice.

## Introduction

Voting is a simple mechanism to combine preferences in multi-agent systems. Unfortunately, results like those of Gibbrard-Sattertwhaite prove that most voting rules are manipulable. That is, it may pay for agents to mis-report their preferences. One appealing escape from manipulation is computational complexity (Bartholdi, Tovey, &
Trick 1989). Whilst a manipulation may exist, perhaps it is computationally too difficult to find? Unfortunately, few voting rules in common use are NP-hard to manipulate with the addition of weights to votes. The small set of voting rules that are NP-hard to manipulate with unweighted votes includes single transferable voting, 2nd order Copeland, ranked pairs (all with a single manipulator), and maximin (with two manipulators) (Bartholdi & Orlin 1991; Bartholdi, Tovey, & Trick 1989; Xia *et al.* 2009).

Borda is probably the only commonly used voting rule where the computational complexity of unweighted manipulation remains open. Xia, Conitzer, & Procaccia (2010)
observe that:
"The exact complexity of the problem [manipulation by a coalition with unweighted votes] is now known with respect to almost all of the prominent voting rules, with the glaring exception of Borda" Copyright c 2018, Association for the Advancement of Artificial Intelligence (www.aaai.org). All rights reserved.

It is known that computing a manipulation of Borda is NP-hard when votes are weighted (Conitzer, Sandholm, &
Lang 2007), and polynomial when votes are unweighted and there is just a single manipulator (Bartholdi, Tovey, & Trick 1989). With a coalition of manipulators and unweighted votes, it has been conjectured that the problem is NP-hard
(Zuckerman, Procaccia, & Rosenschein 2008).

One of our most important contributions is to close this question. We prove that computing a manipulation of Borda with just two manipulators is NP-hard. As a consequence, we treat computing a manipulation as an approximation problem in which we try to minimize the number of manipulators required. We propose two new approximation methods. These methods are based on intuitions from bin packing and multiprocessor scheduling. Experiments show that these methods significantly outperform the previous best known approximation method. They find optimal manipulations in the vast majority of the randomly generated elections tested.

## Background

The Borda rule is a scoring rule proposed by Jean-Charles de Borda in 1770. Each voter ranks the m candidates. A candidate receives a score of m − k for appearing in k th place.

The candidate with the highest aggregated score wins the election. As is common in the literature, we will break ties in favour of the coalition of the manipulators. The Borda rule is used in parliamentary elections in Slovenia and, in modified form, in elections within the Pacific Island states of Kiribati and Nauru. The Borda rule or modifications of it are also used by many organizations and competitions including the Robocup autonomous robot soccer competition, the X.Org Foundation, the Eurovision song contest, anf in the election of the Most Valuable Player in major league baseball. The Borda rule has many good features. For instance, it never elects the Condorcet loser (a candidate that loses to all others in a majority of head to head elections). However, it may not elect the Condorcet winner (a candidate that beats all others in a majority of head to head elections).

We will number candidates from 1 to m. We suppose a coalition of n agents are collectively trying to manipulate a Borda election to ensure a preferred candidate d wins. We let s(i) be the score candidate i receives from the votes cast so far. A *score vector* hs(1)*, . . . , s*(m)i gives the scores of the candidates from a set of votes. Given a set of votes,