we define the gap of candidate i as g(i) = s(d) + n(m −
1) − s(i). For d to win, we need additional votes that add a score to candidate i which is less than or equal to g(i).

Note that if g(i) is negative for any i, then d cannot win and manipulation is impossible.

Our NP-hardness proof uses a reduction from a specialized permutation problem that is strongly NP-complete (Yu, Hoogeveen, & Lenstra 2004).

Definition 1 (Permutation Sum) Given n *integers* X1 ≤
. . . ≤ Xn *where* Pn i=1 Xi = n(n + 1), do there exist two permutations σ and π of 1 to n *such that* σ(i) + π(i) = Xi?

One of our main contributions is to prove that computing a manipulation of the Borda rule is NP-hard, settling an open problem in computational social choice.

## Complexity Of Manipulation

The *unweighted coalition manipulation problem* (UCM)
is to decide if there exist votes for a coalition of unweighted manipulators so that a given candidate wins. As in
(Bartholdi, Tovey, & Trick 1989), we suppose that the manipulators have complete knowledge about the scores given to the candidates from the votes of the non-manipulators.

Theorem 1 Unweighted coalition manipulation for the Borda rule is NP-complete with two manipulators.

Proof: Clearly the problem is in NP. A polynomial witness is simply the votes that the manipulators cast which make the chosen candidate win.

To show NP-hardness, we reduce a Permutation Sum problem over n integers, X1 to Xn, to a manipulation problem with n + 3 candidates. By Lemma 1, we can construct an election in which the non-manipulators cast votes to give the score vector:
hC, 2(n+2)−X1+*C, . . . ,* 2(n+2)−Xn+C, 2(n+2)+*C, y*i where C is a constant and y ≤ C. We claim that two manipulators can make candidate 1 win such an election iff the Permutation Sum problem has a solution.

(⇒) Suppose we have two permutations σ and π of 1 to n with σ(i) + π(i) = Xi. We construct two manipulating votes which have the scores:

$$\langle n+2,\sigma(1),\ldots,\sigma(n),0,n+1\rangle$$ $$\langle n+2,\pi(1),\ldots,\pi(n),0,n+1\rangle$$  Since $\sigma(i)+\pi(i)=X_{i}$, these give a total score vector:
h2(n+ 2)+C, 2(n+ 2)+*C, . . . ,* 2(n+ 2)+C, 2(n+ 1)+yi As y ≤ C and we tie-break in favour of the manipulators, candidate 1 wins.

(⇐) Suppose we have a successful manipulation. To ensure candidate 1 beats candidate n + 2, both manipulators must put candidate 1 in first place. Similarly, both manipulators must put candidate n + 2 in last place otherwise candidate n + 2 will will beat our preferred candidate. Hence the final score of candidate 1 is 2(n + 2) + C. The gap between the final score of candidate 1 and the current score of candidate i + 1 (where 1 ≤ i ≤ n) is Xi. The sum of these gaps is n(n + 1). If any candidate 2 to n + 1 gets a score of n+ 1 then candidate 1 will be beaten. Hence, the two scores of n + 1 have to go to the least dangerous candidate which is candidate n + 3.

The votes of the manipulators are thus of the form:

$$\langle n+2,\sigma(1),\ldots,\sigma(n),0,n+1\rangle$$  $$\langle n+2,\pi(1),\ldots,\pi(n),0,n+1\rangle$$

Where σ and π are two permutations of 1 to n. To ensure candidate 1 beats candidate j for j ∈ [1, n], we must have:
2(n + 2) − Xj + C + σ(j) + π(j) ≤ 2(n + 2) + C
Rearranging this gives:

$$\sigma(j)+\pi(j)\leq X_{j}$$

Since Pn i=1 Xi = n(n+ 1) and Pn i=1 σ(i) = Pn i=1 π(i) =
n(n+1)
2, there can be no slack in any of these inequalities.

Hence, σ(j) + π(j) = Xj That is, we have a solution of the Permutation Sum problem.

✷ Recall that we have assumed that the manipulators have complete knowledge about the scores from the votes of the non-manipulators. The argument often put forward for such an assumption is that partial or probabilistic information about the votes of the non-manipulators will add to the computational complexity of computing a manipulation.

## Approximation Methods

NP-hardness only bounds the worst-case complexity of computing a manipulation. Given enough manipulators, we can easily make any candidate win. We consider next minimizing the number of manipulators required. For example, REVERSE is a simple approximation method proposed to compute Borda manipulations (Zuckerman, Procaccia, &
Rosenschein 2008). The method constructs the vote of each manipulator in turn: candidate d is put in first place, and the remaining candidates are put in reverse order of their current Borda scores. The method continues constructing manipulating votes until d wins. A long and intricate argument shows that REVERSE constructs a manipulation which uses at most one more manipulator than is optimal.

Example 1 Suppose we have 4 candidates, and the 2 nonmanipulators have cast votes: 3 > 1 > 2 > 4 and 2 > 3 >
1 > 4. Then we have the score vector h3, 4, 5, 0i*. We use* REVERSE *to construct a manipulation that makes candidate* 4 *win.* REVERSE *first constructs the vote:* 4 > 1 > 2 > 3.

The score vector is now h5, 5, 5, 3i. REVERSE next constructs the vote: 4 > 1 > 2 > 3*. (It will not matter* how ties between 1, 2 and 3 *are broken). The score vector* is now h7, 6, 5, 6i*. Finally,* REVERSE *constructs the vote:*
4 > 3 > 2 > 1. The score vector is h7, 7, 7, 9i*. Hence,*
REVERSE *requires 3 manipulating votes to make candidate* 4 win. As we see later, this is one more vote than the optimal.