average score. AVERAGE FIT does not allocate the largest unassigned score but the largest such score that will fit into the gap. This avoids defeating d where it is not necessary. If two or more columns can accommodate the same largest average score, we tie-break either arbitrarily or on the column containing fewest scores. The latter is more constrained and worked best experimentally. However, it is possible to construct pathological instances on which the former is better.

## Theoretical Properties

We show that LARGEST FIT is incomparable to REVERSE since there exists an infinite family of problems on which LARGEST FIT finds the optimal manipulation but REVERSE
does not, and vice versa. Full proofs of Theorems 3–4 can be found in (Davies *et al.* 2010).

Theorem 3 For any k*, there exists a problem with* 2k + 2 candidates on which LARGEST FIT *finds the optimal 2 vote* manipulation but REVERSE *finds a 3 vote manipulation.*
Proof: (Sketch) Example 1 demonstrates a problem with 4 candidates on which LARGEST FIT finds the optimal 2 vote manipulation but REVERSE finds a 3 vote manipulation. We can generalize Example 1 to 2k + 2 candidates. ✷
Unlike REVERSE, LARGEST FIT can use more than one extra manipulator than is optimal. In fact the number of extra manipulators used by LARGEST FIT is not bounded.

Theorem 4 For any non-zero k *divisible by 36, there exists* a problem with 4 candidates on which REVERSE *finds the* optimal 2k *vote manipulation but* LARGEST FIT requires at least 2k + k/9 − 3 *votes to manipulate the result.*
Proof: (Sketch) Suppose 2k non-manipulators vote 1 > 2 > 3 > 4 and we want to find a manipulation in which candidate 4 wins. REVERSE finds the optimal 2k vote manipulation in which every manipulator votes 4 > 3 > 2 > 1.

On the other hand, if we have 2k + k/9 − 4 or fewer rows in a relaxed manipulation matrix then it is possible to show that LARGEST FIT will place scores in one of the first three columns that exceed the score of candidate 4. Hence LARGEST FIT needs 2k + k/9 − 3 or more manipulators. ✷
AVERAGE FIT is also incomparable to LARGEST FIT.

Like REVERSE, it finds the optimal manipulations on the elections in the last proof. So far we have not found any instances where REVERSE performs better than AVERAGE FIT. However, there exist examples on which LARGEST FIT finds the optimal manipulation but AVERAGE FIT does not.

Theorem 5 *There exists instances on which* LARGEST FIT
finds the optimal manipulation but AVERAGE FIT *requires* an additional vote.

Proof: (Sketch) We failed to find a simple example but a computer search using randomly generated instances gave the following. Consider an election in which the nonmanipulators wish the last candidate to win, given the score vector:
h41, 34, 30, 27, 27, 26, 25, 14i On this problem, LARGEST FIT finds the optimal manipulation that makes the final candidate win but AVERAGE FIT
requires an additional vote. ✷

## Experimental Results

To test the performance of these approximation methods in practice, we ran some experiments. Our experimental setup is based on that in (Walsh 2010). We generated either uniform random votes or votes drawn from a Polya Eggenberger urn model. In the urn model, votes are drawn from an urn at random, and are placed back into the urn along with b other votes of the same type. This captures varying degrees of social homogeneity. We set b = m! so that there is a 50%
chance that the second vote is the same as the first. In both models, we generated between 2 2and 2 7 votes for varying m. We tested 1000 instances at each problem size. To determine if the returned manipulations are optimal, we used a simple constraint satisfaction problem.

## Uniform Elections

We were able to find the optimal manipulation in 32502 out of the 32679 distinct uniform elections within the 1 hour time-out. Results are shown in Figure 1. Both LARGEST FIT and AVERAGE FIT provide a significant improvement over REVERSE, solving 83% and 99% of instances to optimality. REVERSE solves fewer problems to optimality as the number of candidates increases, while AVERAGE FIT does not seem to suffer from this problem as much: AVERAGE FIT solved all of 4 candidate instances and 98% of the 128 candidate ones. We note that in every one of the 32502 instances, if REVERSE found an n vote manipulation either AVERAGE FIT did too, or AVERAGE FIT found an (n − 1) vote manipulation.

## Urn Elections

We were able to find the optimal manipulation for 31529 out of the 31530 unique urn elections within the 1 hour timeout. Figure 2 gives results. REVERSE solves about the same proportion of the urn instances as uniform instances, 76%.

However, the performance of LARGEST FIT drops significantly. It is much worse than REVERSE solving only 42%
of instances to optimality. We saw similar pathological behaviour with the correlated votes in the proof of Theorem 4. The good performance of AVERAGE FIT is maintained.

It found the optimal manipulation on more than 99% of the instances. It never lost to REVERSE and was only beaten by LARGEST FIT on one instance in our experiments.

## Related Problems

There exists an interesting connection between the problem of finding a coalition of two manipulators for the Borda voting rule and two other problems in discrete mathematics: the problem of finding a permutation matrix with restricted diagonals sums (PMRDS) (Brunetti, Lungo, Del, Gritzmann
& Vries 2008) and the problem of finding multi Skolem sequences (Nordh 2010). We consider this connection for two reasons. First, future advances in these adjacent areas may give insights into new manipulation algorithms or into the complexity of manipulation. Second, this connection reveals an interesting open case for Borda manipulation - Nordh has conjectured that it is polynomial when all gaps are distinct.