
## 3.2 Operations On Labeled Constraints

The following points define the main operations on labeled constraints.

3.2.1 TEMPORAL INCLUSION ⊆LC
The temporal inclusion operation ⊆lc should take into account the inclusion of temporal intervals and the inclusion of associated label sets:
lecij.k ⊆lc lecij.p = (ecij.k {labelij.k}) ⊆lc (ecij.p {labelij.p}) =def ecij.k ⊆T ecij.p ∧ {labelij.k}⊆ {labelij.p}.

3.2.2 TEMPORAL UNION ∪LC
Operation ∪lc performs the disjunctive temporal union of labeled constraints as the set-union of their elemental constraints. However, all labeled elemental constraints whose associated labels are I-L-Sets should be rejected.

lcij ∪lc lc'ij =def ∀lecij.k∈lcij, ∪lc [{lecij.k} lc'ij] , where
∪lc [{lecij.k} lc'ij] = (ecij.k{labelij.k}) ∪lc lc'ij =def Inconsistent({labelij.k}) : lc'ij

$\star$ ? 
$\frac{2}{3}$ 2. 
$$\exists\mathrm{lce}_{i j p}\!\in\!\mathrm{lc}^{\prime}_{i j}\:/\:\mathrm{lce}_{i j p}\!\subseteq\!\mathrm{lc}_{i j k}\!\cdot\!\mathrm{lce}^{\prime}_{i j}$$  Other : ($\{\mathrm{lce}^{\prime}_{i j}\}\cup\{\mathrm{lce}_{i j k}\}$) - ($\{\mathrm{lce}_{i j p}\}$, $\forall\mathrm{lce}_{i j p}\!\in\!\mathrm{lc}^{\prime}_{i j}\wedge\mathrm{lce}_{i j k}\!\subseteq\!\mathrm{lc}_{i p}$)
The function Inconsistent({label*ij.k*}) returns *true* if the set {labelij.k} is an I-L-Set or a superset of any existing I-L-Set (*Theorem 1*). Otherwise, it returns *false*:

## Inconsistent({Labelij.K}) =Def

If ∃{labels}∈Inconsistent-Label-Sets / {labels}⊆{labelij.k} Then *True* Else *False.*
The operation ∪lc simplifies the resulting constraint. Equal or less-restricted elemental constraints with equal or bigger associated label sets are removed. For instance:
{([10 30]{R1 R3 R5 R9}), ([40 40]{R6 R7})} ∪lc {([10 20]{R1 R3}), ([40 40]{R6 R7 R8})} =

$$(s_{I})$$
$\left({\mathfrak{S}}_2\right)$. 
{([10 20]{R1 R3}), ([40 40]{R6 R7})}.

In the resulting constraint, ([10 30]{R1 R3 R5 R9}) and ([40 40]{R6 R7 R8}) are eliminated, as examples of the cases s1 and s2, respectively. That is, ([10 20]{R1 R3}) ⊆lc ([10 30]{R1 R3 R5 R9}) and ([40 40]{R6 R7})
⊆lc ([40 40]{R6 R7 R8}). These simplifications can seem counter-intuitive. However, note that the label set associated to each derived-labeled elemental constraint represents the support set (composed of input elemental constraints) from which the derived-labeled elemental constraint is obtained. Thus, only the minimal associated label set should be represented, for reason of efficiency. Moreover, the more labels are in the associated label set {labelij.k}, the elemental constraint (ecij.k) should be equal or more restricted.

## 3.2.3 Temporal Composition ⊗Lc

Operation ⊗lc performs the temporal composition of labeled constraints. It is based in the operation
⊗ of the underlying disjunctive metric point-based algebra.