lcij ⊗lc lcjk =def ∀lecij.p∈lcij, ∀lecjk.q∈lcjk ∪lc [ (ecij.p ⊗ ecjk.q {labelij.p}∪{labeljk.q})].

For instance: {([0 10]{R1}), ([20 30]{R2})} ⊗lc {([100 200]{R3}), ([300 400]{R4})} =
{([320 430]{R4 R2}), ([300 410]{R4 R1}), ([100 210]{R3 R1}), ([120 230]{R3 R2})}.

Note that elemental constraints in a labeled derived constraint may not be pairwise disjoint.

However, these labeled derived elemental constraints cannot be simplified. This is related to the fragmentation problem of the disjunctive metric algebra (Schwalb & Dechter, 1997). We have that each derived-labeled elemental constraint should have its own associated label set. In the example,
(([320 430]{R4 R2}), ([300 410]{R4 R1})) cannot be simplified to ([300 430]{R4 R2 R1}) since each subinterval depends on a different set of labels (that is, on a different support-set of elemental constraints). If the label set {R4 R2} becomes an I-L-Set, only ([320 430]{R4 R2}) should be removed.

On the other hand, if [300 410] becomes an inconsistent interval between the implied time points, only {R4 R1} should be asserted as an I-L-Set.

3.2.4 TEMPORAL INTERSECTION ⊕LC
Operation ⊕lc performs the temporal intersection of labeled constraints and is based on the operation
⊕.

lcij ⊕lc lc'ij =def ∀lecij.k∈lcij, ∀lecij.p∈lc'ij , ∪lc [lecij.k ⊕lc lecij.p]
where, lecij.k ⊕lc lecij.p =def If ecij.k ⊕ ecij.p= ∅ Then {∅} ;The Inconsistent-Constraint is returned.

$\frac{1}{2}$ 4. 
Else [(ecij.k ⊕ ecij.p) ({labelij.k}∪{labelij.p})]
As example:
{([0 10]{R1}), ([20 25]{R2})} ⊕lc {([0 30]{R3}), ([40 50]{R4})} = {([20 25]{R3 R2}), ([0 10]{R3 R1})}
In the operations ⊗lc and ⊕lc, the label set {labelij.r} associated to each derived labeled-elemental constraint (ecij.r) is obtained from the set-union of labels associated to combined (⊗lc) or intersected (⊕lc) labeled-elemental constraints. Therefore, {labelij.r} represents the support set (composed of input elemental constraints) that implies the derived elemental constraint (ecij.r).

Definition 4. A set of I-L-Sets is complete if it represents all inconsistent sets of TCN elemental constraints. A set of I-L-Sets is sound if each I-L-Set represents an inconsistent set of elemental constraints. ◊ Theorem 2. Assuming a complete and sound set of I-L-Sets, a labeled elemental constraint is consistent iff it has an associated label set which is not an I-L-Set. The proof is trivial, since the label set associated to each labeled elemental constraint represents its support-set. ◊ Theorem 3. Assuming a complete and sound set of I-L-Sets, no inconsistent labeled elemental constraint is obtained in operations ⊗lc and ⊕lc.

Proof: The operations ⊗lc and ⊕lc use the operation ∪lc to obtain their results. This operation ∪lc rejects all labeled elemental constraints whose associated labels are I-L-Sets. Thus, all elemental constraints derived in operations ⊗lc and ⊕lc are consistent (*Theorem 2*). ◊