Algebra (IA) introduced by Allen (1983) represents symbolic (*qualitative*) constraints between intervals but metric information, such as 'interval1 *starts 2 seconds before interval*2', cannot be included. Metric (*quantitative*) point-based models (Dechter, Meiri & Pearl, 1991) include the 'time line' (metric) in their constraints, but they can only represent a limited subset of disjunctive constraints between intervals. Thus, constraints like 'interval1 *{bef, aft} interval*2' cannot be represented (Gerevini & Schubert, 1995).

Some efforts have been made to integrate qualitative and quantitative temporal information on points and intervals (Kautz & Ladkin, 1991; Drakengren & Jonsson, 1997; etc.). Particularly, Meiri
(1996) introduces *Qualitative Algebra* (QA), where each interval is represented by three nodes (one representing the interval and the other two representing its extreme points) such that QA can represent qualitative and metric constraints on points and intervals. Badaloni and Berati (1996) define the Interval Distance Sub Algebra (IDSA), where nodes are intervals. These intervals are related by disjunctive 4-tuple-metric constraints between their ending time points {(I
-
i, I
-
j), (I
+
i, I
-
j), (I
-
i, I
+
j), (I
+
i, I
+
j)}. Staab and Hahn (1998) propose a model for reasoning on qualitative and metric boundaries of intervals. However, these models cannot handle constraints on *interval durations*, which were identified earlier by Allen (1983). Constraints such as 'interval1 *lasts 2 seconds more than interval*2' require a high-order expression (Dechter et al., 1991), or a *duration* primitive which should be integrated with interval and point constraints (Allen, 1983; Barber, 1993). Particularly, Barber (1993)
proposes two orthogonal networks to relate constraints on durations and time points. Navarrete
(1997) and Wetprasit and Sattar (1998) relate disjunctive constraints on durations and time points, but only a limited subset of interval constraints is managed. More recently, Pujari and Sattar (1999)
propose a framework for reasoning on points, intervals and durations (PIDN). Here, variables represent points or intervals, and constraints are an ordered set of three intervals representing (Start, End, Duration) subdomains. However, no specialized algorithms for management of PIDN
constraints are proposed.

In relation to the complexity of reasoning algorithms, the consistency problem is polynomial in PA (Vilain, Kautz & Van Beek, 1986) and in non-disjunctive metric networks (Dechter et al., 1991).

However, Vilain, Kautz and Van Beek (1986) also showed that determining the consistency of a general-case temporal network (i.e.: disjunctive qualitative and metric constraints between points, intervals or durations) is NP-hard. Thus, in previous qualitative or quantitative models, the consistency problem is tractable only under some properties on constraints, relationships between variable domains and constraints, or by using restricted subsets of constraints (Dechter et al., 1991; Dechter, 1992; van Beek & Detcher, 1995; Wetprasit & Sattar, 1998; Jeavons et al., 1998; etc.). For instance, tractable subclasses of IA have been identified by Vilain, Kautz and Van Beek (1986),
Nebel and Burckert (1995), Drakengren and Jonsson (1997), etc. Moreover, some interesting results have been obtained in identification of tractable subclasses of QA. Specifically, Jonsson et al. (1999)
identified the five maximal tractable subclasses of the qualitative point-interval algebra. However, to my knowledge the maximal tractable subclass of PIDN model (maximal tractable subclass of qualitative and quantitative point, interval and duration constraints) is still not identified. In any case, these restricted tractable subclasses are not able to obtain expressiveness of full models, and the problem of reasoning on disjunctive constraints on points and intervals remains NP-complete.

On the other hand, these qualitative and metric temporal models do not manage certain types of non-binary constraints, which are important for modeling some problems (scheduling, causal reasoning, etc.). For instance, disjunctive assertions like '(interval1 {bef, meets} interval2) ∨ (time-