For instance, in Example 2 of Figure 10, the partial instantiation {(t1=0), (t2=5), (t3=5)} is consistent. We have:
([0 45]{R0 R3})∈lc10 / 0∈[0 45], ([0 60]{R1 R0 R3})∈lc20 / 5∈[0 60], ([5 55]{R0 R1 R3})∈lc30 / 5∈[5 55],
and {R0 R3}∪{R0 R1 R3}∪{R0 R1 R3}={R0 R1 R3} is not an IL-Set. Thus, this partial solution can be extended to a global solution. For instance, {(t1=0), (t2=5), (t3=5), (t4=25)}.

Therefore, a labeled-TCN can be considered as a *globally labeled-consistent* TCN. That is, on the basis of the concepts introduced by Dechter (1992):
Definition 6. *(Local Labeled-consistency):* A partial instantiation of variables (1≤k<n) {t1=v1, t2=v2,
..., tk=vk} is local labeled-consistent if it is *labeled-consistent* with respect to (T0, t1, t2, ..., tk) nodes.

This also holds for k=n. ◊
Definition 7. *(Global Labeled-consistency):* A labeled sub-TCN (with the global set of I-L-Sets) is global labeled-consistent if any partial instantiation of variables in the sub-TCN, which is local labeled-consistent, can be extended to the overall TCN. A globally labeled-consistent TCN is one in which all its sub-TCNs are globally labeled-consistent. ◊
Theorem 11. At each new assertion, the proposed reasoning processes obtain a *globally labeledconsistent* TCN, if they are applied on a previous minimal TCN and a previous sound and complete set of I-L-Sets.

Proof: The proof is trivial according to the previous definitions (Definition 6 and Definition 7) and to the properties of the reasoning processes (Theorem 7 and Theorem 8). Any partial instantiation in any subTCN, which is labeled-consistent with respect to the nodes involved in the partial instantiation, is overall consistent (*Theorem 10*). ◊
Similar expressions can be made for *k-labeled-consistency* and *strong k-labeled-consistency* on the basis of the concepts provided by Freuder (1982). Therefore, the set of I-L-Sets in a labeled-TCN
provides a useful way to assure whether a local instantiation of variables can be part of a global solution. Moreover, Freuder (1982) shows that in a strong k-consistent TCN, consistent instantiations of variables of any subnetwork of size k can be found in a backtrack-free manner and in any variable ordering. This is also a consequence of the decomposability (Montanari, 1974; Dechter et al., 1991) or globally consistency (Dechter, 1992) properties. Obviously, this feature also holds for labeled TCNs.

## 4.5 Analysis Of Temporal Complexity

Let's analyze the computational cost of the proposed reasoning processes. These processes are, basically, an *incremental* path-consistent algorithm (Barber, 1993). At each updating process of a new input constraint on a TCN with n nodes, the computational cost of updating and closure processes is bounded by 'n 2(O(⊗lc) + O(⊕lc))'. In the proposed reasoning process, the path-consistent algorithm obtains a minimal disjunctive metric TCN. This is possible due to the management of labeled constraints, associated label sets, and I-L-Sets. Thus, the complexity of reasoning processes is mainly due (instead of a complex closure process) to the management of complex data structures
(labeled constraints, associated label sets, and I-L-Sets). That is, the complexity of the proposed