
## 5.2 Metric Constraints On Intervals

Metric constraints between intervals can also be managed in the described temporal model. From a general point of view, metric information can be added to each elemental interval-based constraint in a standard way (Table 4). These metric constraints on interval boundaries (Table 4) are similar to the ones proposed by Staab and Hahn (1998).

| IA Symbolic Elemental Constraints                    | IA Metric Elemental Constraints   |     |       |
|------------------------------------------------------|-----------------------------------|-----|-------|
| cij≡ {[dm1 dM1], [dm2 dM2], [dmn dMn]}               |                                   |     |       |
| c'ij≡ {[dm'1 dM'1], [dm'2 dM'2], [dm'n dM'n]} Ii Cij |                                   |     |       |
| Ii  before Ij                                        | Ii (before cij) Ij                | Ij  |       |
| Ii                                                   | Cij                               |     |       |
| Ii meets Ij                                          | Ii (meets cij) Ij                 | Ij  |       |
| Ii                                                   | C'ij                              |     |       |
| Ii  during Ij                                        | Ii (cij  during c'ij) Ij          | Cij | Ij Ii |
| Cij                                                  |                                   |     |       |
| Ii starts Ij                                         | Ii (starts cij) Ij                | Ij  |       |
| Ii                                                   | Cij                               |     |       |
| Ii finishes Ij                                       | Ii (finishes cij) Ij              | Ij  |       |
| Ii                                                   |                                   |     |       |
| Ii  overlaps Ij                                      | Ii (overlaps cij) Ij              | Ij  |       |
| Cij Ii                                               | C'ij                              |     |       |
| Cij                                                  |                                   |     |       |
| Ii equal Ij                                          | Ii (cij equal c'ij) Ij            | Ij  |       |

Obviously, the metric constraints of Table 4 can be managed in the proposed model, by means of metric constraints on interval ending points. Thus, symbolic constraints of Interval Algebra can be extended in this way to metric domain. However, since each interval is represented by means of its ending time-points, more flexible metric constraints on intervals can be represented by means of metric constraints on their ending time-points. In this way, the described model also subsumes the Interval Distance Sub Algebra model proposed by Badaloni and Berati (1996). Moreover, ending points of intervals can also be related to the initial time-point T0, and unary metric constraints on interval durations can be expressed by means of metric constraints between the two ending points of each interval:
dur (Ii) = {[dm1 dM1], [dm2 dM2], ..... [dmn dMn]} ⇒

(I${}_{i}$ {[dm${}_{1}$ dM${}_{1}$], [dm${}_{2}$ dM${}_{2}$],.... [dm${}_{n}$ dM${}_{n}$]} I${}_{i}$+).  
$$\mathbf{n_{n}}\,\mathrm{d}\mathbf{M_{n}}]\}\ \Rightarrow$$