The resulting label set associated to each context-dependent derived elemental constraint represents the contexts where the elemental constraint holds, as well as the hierarchy of predecessor contexts of the elemental constraint. For instance, Figure 16 shows the contextual labeling for the example in Figure 13. Moreover, after successively performing the updating and closure processes for all constraints in this example, we have the following constraint between nodes n1 and n2:
(n1 lc12 n2): (n1 {[0 100]{R1 W0}, [200 300]{R2 W0}, [0 50]{R3 R1 W1 W0}, [200 210]{R4 R2 W1 W0}, *(e3)*
[60 100]{R5 R1 W2 W0}, [290 300]{R6 R2 W2 W0}, [0 25]{R7 R1 W3 W0}, [260 280]{R8 R2 W3 W0},
[0 25]{R0 R3 R1 W11 W1 W0}, [30 50]{R9 R3 R1 W12 W1 W0}, [200 205]{R10 R2 R4 W12 W1 W0},

![0_image_0.png](0_image_0.png)

[0 20]{R0 R7 R1 W31 W3 W0}, [210 215]{R0 R2 R8 W32 W3 W0}, [260 280]{R0 R2 R8 W33 W3 W0}} n2)
No closure process is performed among constraints belonging to contexts of different hierarchies.

According to *Put-label-context* function, each pair of labels related to the successor contexts of each context is an I-L-Set. Thus, these I-L-Sets prevent deriving elemental constraints from contexts of different hierarchies. That is, each derived elemental constraint obtained (combining or intersecting)
from two elemental constraints in contexts of different hierarchy will have an inconsistent associated label set. Therefore, these derived elemental constraints will be rejected in the operation ∪lc. For instance, in the example of Figure 13, {{W1, W2}, {W1, W3}, {W2, W3}, {W11, W12}, {W31, W32},
{W31, W33}, {W32, W33}} are I-L-Sets. Thus, if a constraint is asserted in context W1:

i) No propagation is performed using constraints in contexts W11 and W12 simultaneously, since {W11, W12} is an I-L-Set.

ii) No propagation is performed in context W2, nor in W3, nor in their successors, since {W1, W2} and {W1 W3} are I-L-Sets.
Let's see an example of the Context-Update and Context-Closure processes. Let's assume that the context-dependent constraints in Figure 13 are already updated and closured, such that the previous constraint lc12 *(expression e3)* exists between n1 and n2. Now, we update (n1 {[20 40]} n2) in context W1. The call to *Consistency-Test* function in the Context-Update function is:
Consistency-Test (get-upward (n1, n2, W1), {[20 40]{R0 W1}}).

Given the previous constraint lc12 between n1 and n2 *(expression e3)*, the function performs:
{[0 50]{R3 R1 W1 W0}, [200 210]{R4 R2 W1 W0}, [0 25]{R0 R3 R1 W11 W1 W0},