Thus, the asserted constraint between (n3, n2) in context W1 is closured in the context W1 and in all its successor contexts (W11 and W12). Likewise, the closure process does not perform any propagation simultaneously using constraints of the contexts W11 and W22, nor any of the context W2, W3, nor any of their successors.

## 7.2 Complete Versus Incomplete Partition Of Contexts

In each updating process, the consistency of each new constraint lc'ij in a given context is assured in this context and in all its parent contexts. Let's deal with consistency issues between a context and its successor contexts. Here, we have that constraints in a given context Wi can be either completely covered or only partially covered by the existing constraints in the successor contexts of Wi. That is, the successor contexts of Wi can be either a complete partition or only a partial partition of Wi.

For instance, let's assert the constraint (n1 {[210 210]{R0 W1}} n2) in the context W1 of the example in Figure 13. In the *Consistency-test* function, we have (where the constraint lc12 is the previous expression e2):
get-upward (n1, n2, W1) ⊕lc {[210 210]{R0 W1}} =
{[0 50]{R3 R1 W1 W0}, [200 210]{R4 R2 W1 W0}, [0 25]{R0 R3 R1 W11 W1 W0}, [30 50]{R9 R3 R1 W12 W1 W0},
[200 205]{R10 R2 R4 W12 W1 W0}} ⊕lc {[210 210]{R0 W1}} = {[210 210]{R0 W1 R4 R2 W0}}.

That is, the asserted constraint is consistent with the existing constraints in context W1. However, no resulting elemental constraint is associated to context W11 nor W12. This means that the asserted constraint (n1 {[210 210]{R0 W1}} n2) is consistent in W1, but is inconsistent in W11 and in W12. Here, two alternatives appear:

i) To assume that existing successor contexts are a complete partition of their parent context.

Therefore, a new constraint cij in a context Wi should be rejected, if cij is inconsistent in all successor contexts of Wi. For instance, we can assume that W11 and W12 in Figure 13 are a complete partition of W1. Thus, (n1 {[210 210]{R0 W1}} n2) should be rejected.

ii) To assume that successor contexts are not a complete partition of their parent context. Therefore, successor contexts become inconsistent and they should be removed. In the example, we can assume that contexts W11 and W12 are not a complete partition of the context W1, such that another possible new successor context of W1 would be able to match in the future the asserted constraint (n1 {[210 210]{R0 W1}} n2). In this case, the constraint (n1 {[210 210]{R0 W1}} n2) is assumed to be correct, such that it can be asserted in the TCN. Therefore, the contexts W11 and W12 become inconsistent. {W11} and {W12} should be added to the set of I-L-Sets, such that these contexts (and all their successor contexts and all their constraints) become inconsistent and removed from the TCN. That is, all elemental constraints with an associated label set containing
{W11} or {W12} should be removed.
In both cases, each context will always be consistent with all its successor contexts. The option to be adopted can depend on the problem type to solve (Garrido et al., 1999). Any of the these options can be easily introduced in the described reasoning processes, since the function *Consistency Test* can determine which successor contexts (Ws) become inconsistent at each new constraint (lc'ij ) in a context (Wk):