Time points are instantiated on D (ti∈D), and temporal intervals can be modelled as pairs of ending time points that can be instantiated on D: Ii = (Ii
-, Ii
+), Ii∈DxD, Ii
-≤Ii
+.

- *Temporal constraints* between primitives, where each constraint relates n primitives: c1,2..n(x1, x2, ..., xn). As particular cases, the 'empty constraint' {∅} is named the Inconsistent-Constraint and 'U' is the Universal-Constraint. *Unary-constraints* restrict the interpretation domain D for variables. They are not usually used in symbolic algebras, where an infinite domain is assumed. *Binary-constraints* are temporal constraints between two variables (xi cij xj), and nary-constraints represent temporal constraints among n variables. By default, binary constraints are assumed in this paper. We can also have *qualitative* (relative relation) or *quantitative*
(metric relation) constraints, as well as disjunctive (cij is a set of disjunctive basic constraints, |cij|≥1) or non-disjunctive constraints.

- *Operations between constraints.* Mainly, Temporal Composition (⊗), Temporal Intersection
(⊕), Temporal Union (∪Τ), and Temporal Inclusion (⊆Τ).
A temporal problem is specified by a set of n variables X= {xi}, an interpretation domain D and a finite set of temporal constraints between variables {(xi cij xj)}. A temporal problem gives rise to a *Temporal Constraint Network* (TCN) which can be represented as a directed graph where nodes represent temporal primitives (xi) and labeled-directed edges represent the binary constraints between them (cij). The Universal Constraint U is not usually represented in the graph, and each direct edge
(representing cij) between xi and xj implies an inverse one (representing cji) between xj and xi.

According to the underlying Temporal Algebra, we mainly have IA-TCNs based on the Interval Algebra (Allen, 1983), PA-TCNs based on the Point Algebra (Vilain et al., 1986), or Metric-TCNs based on the Metric Point Algebra (Dechter et al., 1991; Dean & McDermott, 1987). In this later case, disjunctive metric point-based constraints give rise to a Temporal Constraint Satisfaction Problem (TCSP) (Dechter et al., 1991).

Reasoning on temporal constraints can be seen as a Constraint Satisfaction Problem (CSP). An instantiation of the variables X is a n-tuple (v1, v2, v3, ...,vn) / vi∈D which represents the assignments of values {vi} to variables {xi}: (x1=v1, x2=v2, ...,xn=vn). A (global) *solution* of a TCN is a consistent instantiation of the variables X in their domains such that all TCN constraints are satisfied. A value v is a *consistent (or feasible) value* for xi if there exists a TCN solution in which xi=v. The set of all feasible values of a variable xi is the *minimal domain* for the variable. A constraint (xi cij xj) is consistent if there exists a solution in which (xi cij xj) holds. A constraint cij is *minimal* iff it consists only of consistent elements (or feasible values) that is, those which are satisfied by some interpretation of TCN constraints. A TCN is *minimal* iff all its constraints are minimal.

A TCN is *consistent* (or *satisfiable*) iff it has at least one solution. Freuder (1982) generalizes the notion of consistency as: 'a network is *k-consistent* iff (given any instantiation of any k-1 variables satisfying all the direct constraints among those variables) there exists at least one instantiation of any kth variable such that the k values taken together satisfy all the constraints among the k variables'. As consequences: (i) all (k-1)-length paths in the network are consistent, (ii) for each pair or nodes, there exists an interpretation that satisfies each (k-1)-length path between them, and (iii) each sub-TCN of k-nodes is consistent. As particular cases, 1-consistency, 2-consistency and 3-consistency are called node-consistency, arc-consistency and path-consistency, respectively (Mackworth, 1977; Montanari, 1974).