Path-consistency is a common concept in constraint networks. From Montanari (1974) and Mackworth (1977), 'a path of k-length through nodes (x1, x2, ..., xk, xj) is path-consistent iff for any value v1∈d1 and vj∈dj such that (x1=v1 c1j xj=vj) holds, there exists a sequence of values v2∈d2, v3∈d3,
..., vk∈dk such that (v1 cl2 v2), (v2 c23 v3),...., and (vk ck,j vj) hold'. A TCN is *path-consistent* iff all its paths are consistent. Moreover, Montanari (1974) proves that to ensure path-consistency it suffices to check every 2-length path. Thus, path-consistency and 3-consistency are equivalent concepts.

Alternatively, Meiri (1996) outlines a path of k-length (xi, x1, x2, ...,xk, xj) is path-consistent iff cij ⊆Τ
(ci1 ⊗ c12⊗ ... ⊗ ckj). However, this definition disregards domain constraints, such that it is equivalent to the former definition if variable domains are infinite or the TCN is also node and arc-consistent, as the usual case in symbolic algebras. In metric algebras, path-consistency usually assumes node and arc-consistency. Therefore, taking into account that it is only necessary to test 2-length paths to assure path-consistency, a TCN is path-consistent iff ∀cij,cik,ckj⊆TCN, cij ⊆Τ (cik ⊗ ckj). This condition gives rise to the more usual path-consistent algorithm: the Transitive Closure Algorithm
(TCA) which imposes local 3-consistency in each sub-TCN of 3 nodes, such that all 2-length paths become consistent paths (Mackworth, 1977; Montanari , 1974). The TCA algorithm will obtain an equivalent path-consistent TCN if it exists. Otherwise, it fails.

## ∀Cij,Cik,Ckj⊆Tcn: Cij←Cij ⊕ (Cik ⊗ Ckj)

A network is *strong k-consistent* iff the network is j-consistent for all j≤k (Freuder, 1982). An nconsistent TCN is a consistent TCN, and a strong n-consistent TCN is a minimal TCN. Alternatively, Dechter (1992) introduces the concepts of local and global consistency: A partial instantiation of variables (x1=v1, x2=v2, ...,xk=vk) / 1≤k<n is *locally consistent* if it satisfies all the constraints among these variables. A subTCN is *globally consistent* if any locally consistent instantiation of the variables in the subTCN can be extended to a consistent instantiation of all TCN. A *globally* consistent TCN is one in which all its subTCNs are globally consistent. Thus, a TCN is strong nconsistent iff it is globally consistent (Dechter, 1992).

The first reasoning task on a TCN is to determine whether the TCN is consistent. If the TCN is consistent, we can then obtain the minimal-TCN, all TCN solutions (by assuming a discrete and finite model of time), only one solution, a partial solution (consistent instantiation of a subset of TCN
variables, which is a part of a global solution), etc.

Deductive closure, or propagation, is one of the basic reasoning algorithms. The *closure* process is a deductive process on a TCN, where new derived constraints are deduced from the explicitly asserted ones by means of the composition (⊗) and intersection (⊕) operations. Thus, the process of determining the consistency and the minimality of a TCN is related to a *sound* and *complete* closure process (Vilain et al., 1986). Alternatively, CSP-based methods (with several heuristic search criteria)
are also used for guaranteeing consistency and obtaining TCN solutions. In this paper, we are mainly interested in TCN closure processes.

Determining the consistency of a general-case TCN is NP-hard, and Minimal TCNs can be obtained by a polynomial number of consistency processes (Vilain et al., 1986). Particularly, Dechter, Meiri and Pearl (1991) showed that determining consistency and obtaining a minimal disjunctive metric TCN can be achieved in O(n 3l e), where 'n' is the number of TCN nodes, 'e' is the number of explicitly asserted (input) constraints, and 'l' is the maximum number of intervals in an input constraint. However, specific levels of k-consistency can guarantee consistency and obtain a minimal TCN, depending on the TCN topology or the underlying temporal algebra. For example, path-