
## Overcoming Misleads In Logic Programs By Redefining Negation M. A. El-Dosuky A, T. T. Hamza A , M. Z. Rashad A And A. H. Naguib B

a Faculty of Computers and Information sciences, Mansoura University, Egypt E-mail: mouh_sal_010@mans.edu.eg b Faculty of Sciences, Mansoura University, Egypt Negation as failure and incomplete information in logic programs have been studied by many researchers In order to explains HOW a negated conclusion was reached, we introduce and proof a different way for negating facts to overcoming misleads in logic programs. Negating facts can be achieved by asking the user for constants that do not appear elsewhere in the knowledge base. 

Keywords: logic programming, negation as failure, incomplete information, justification

## 1. Introduction

Negation as failure and incomplete information in logic programs have been studied by many researchers, mainly because of their role in the foundations of declarative reading of logic programming. This paper gives a review of some of the definitions of the concepts related to of the declarative reading of logic programming. Then, the paper provides a framework to overcome misleads and to solve a misleading case study. The paper begins with reviewing the relevant work of contributions to logic programming emphasizing many concepts such as negation as failure, closed world assumption, incomplete information, and their consequences (Section 2). Then we comment on the standard definitions of the relevant logic programming concepts such as: compound terms, substitution, common instance, facts, rules, reduction, variables quantification, unifier, Most General Unifier (MGU), computation, and structured data (Section 3). 

Then we briefly discuss the semantics of logic programming. A logic program can have many semantics according the point of view. The common semantics are operational, denotational, and declarative (Section 4). Then we present our framework for overcoming misleads in logic programs using negation as invalid 
(Section 5). Then we investigate the features of the presented framework in the next section. 

## 2. Related Work

Different research communities have investigated various aspects of the declarative readings of logic programming. 

Logic programming languages are a great tool for knowledge representation. The main non-monotonic feature is *Negation As Failure* [Clark1978] . It enables to express knowledge not readily expressible in classical logic. However, these languages cannot directly represent incomplete knowledge about the world. 

A consistent classical theory distinguishes between three types of sentences : provable, refutable, and undecidable. However, a logic program answers either yes or no, with no counterpart for undecidable sentences which represent the incompleteness of information. The reason for this is due to the declarative semantics of logic programming automatically applies the *closed world assumption* [Reiter1978]. It states that each ground atom that does not follow from the facts in the program is assumed to be false. The causal logic [Bochman 2004] is shown to make any causal logic program satisfies the *Negation As Default* principle (alias Closed World Assumption). 

Many attempts are made to allow for the correct representation of *incomplete information*. The first is probably due to Jack Minker [Minker1982] . Another attempt is to expand the language of logic programs with classical negation as failure by modal operators K and M defined with details in [Gelfond1994]. For the set of rules T and formula F, KF stands for "F is known to be true by a reasoner with a set of premises T" and MF means "F may be believed to be true". Incomplete information can be captured by communicating other intelligent parities [Rosati2003]. This framework is well-suited for representing situations in which an agent cooperates in a team, and each agent is able to communicate his knowledge to other agents in the team. Logic programming - and negation as failure - has many declarative readings. One view is that logic programming is a logic for default reasoning. In this view, negation as failure is a modal operator. In an alternative view, a logic program is interpreted as a definition. In this view, negation as failure is the classical objective negation [Denecker 2000]. There is an *epistemological ambiguity* that arises in the context of logic programming [Denecker 2004]. There are several logic programming formalisms, each has a pair of a formal syntax and a formal semantics. [Denecker 2004] falsifies our assumptions that that each such pair has a unique declarative reading and for a program in several formal logics shall its declarative reading is the same in each of them. 

1 