
## 4.2. Declarative Reading Of Logic Programs

One feature of the declarative reading of logic programs that makes it very useful is the justification and explanation of HOW and WHY this semantics characterizes this declarative reading [Denecker 2000].

Explanation is an important facility provided by expert systems [Merritt1989]. The system must be able to explain HOW it arrived a conclusion and WHY it is performing some computation. To answer how a conclusion was reached, work back through the inference chain. To answer why a computation is being performed, the system must state its current goal. Figure 1 applies this concept on a simple rule. Decision 1 was made true because Facts 1, 2, 3 are true. The system may ask the user if fact 3 is true, because it is trying to determine if decision 1 should be made. 

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

Figure 1: HOW and WHY Explanation of a simple rule Definition: Interpretation Let P be a logic program. Let *U(P)* be Herbrand Universe of P and *B(P)* be Herbrand Base of P. *U(P)* is the set of all ground terms that can be formed from the constants and function symbols appearing in P. *B(P)* is the set of all ground goals that can be formed from predicates in P and the terms in the Herbrand universe. 

An interpretation of a logic program is a subset of the Herband base.

For a review for the famous Herbrand theorem and new sequent forms of Herbrand theorem and their applications, you can refer to [Lyaletski2006]. Definition: Model Let P be a logic program. Let I be an interpretation. I is a model for P if for each ground instance of a clause AÅ *B1, …, Bn* in P A is in I if *B1, …, Bn* are in I.

Definition: Minimal Model Let P be a logic program. Let *M(P)* be minimal model of P. *M(P)* is the intersection of all models. The minimal model is the declarative meaning of a logic program Definition: Mapping Let P be a logic program. Let TP be natural mapping from interpretations to interpretations. 

TP(I) = { A in B(P) : A Å B1, …, *Bn, n ≥ 0,* is a ground instance of a clause in P, and *B1,* …, Bn are in I}. 

Definition: Intended meaning Let P be a logic program. Let M be the intended meaning of P. M is a set of ground goals intended by programmer for the program to compute. Definition: Correctness Let P be a logic program. Let M be the intended meaning of P. P is correct with respect to M if *M(P)* is contained in M. Definition: Completeness Let P be a logic program. Let M be the intended meaning of P. P is complete with respect to M if M is contained in *M(P)*. 

For a comprehensive review for declarative reading of logic programs, you can refer to ([Sterling& Shapiro 1994] , [Lyaletski2006] , and [Denecker 2000]). 

## 5. Overcoming Misleads In Logic Programs By Redefining Negation 5.1 Motivation

Sometimes it is very hard to explain HOW a negated conclusion was reached. Consider the following verbal problem [Dow&Mayer 2004]: 
Marsha and Marjorie were born on the same day of the same month of the same year to the same mother and the same father yet they are not twins. How is that possible? 