Although several aspects of the logic MBNF have been thoroughly investigated (Schwarz
& Lifschitz, 1993; Chen, 1994; Bochman, 1995), the existing studies concerning the computational properties of MBNF are limited to subclasses of propositional MBNF theories
(Inoue & Sakama, 1994) or to a very restricted subset of the first-order case (Beringer &
Schaub, 1993).

In this paper we present a computational characterization of deduction in the propositional fragment of MBNF. In particular, we show that logical implication in the propositional fragment of MBNF is a H 2 -complete problem: hence, it is harder (unless the polynomial hierarchy collapses) than reasoning in all the best known propositional formalisms for nonmonotonic reasoning, like autoepistemic logic (Niemela, 1992; Gottlob, 1992), default logic (Gottlob, 1992), circumscription (Eiter & Gottlob, 1993), (disjunctive) logic programming (Eiter & Gottlob, 1995), and several McDermott and Doyle's logics (Marek & Truszczyński, 1993).  As shown in the following, this result also implies that minimal knowledge is computationally harder than negation as failure.

Moreover, we study the subclass of flat MBNF theories, i.e. MBNF theories without nested occurrences of modalities, showing that in this case logical implication is n 2 -
complete. This case is the most interesting one from the logic programming viewpoint. Indeed, it implies that, under the stable model semantics, increasing the syntax of program rules, by allowing propositional formulas as goals in the rules, does not affect the worst-case complexity of query answering for disjunctive logic programs with negation as failure.

Furthermore, we provide algorithms for reasoning both in MBNF and in its flat fragment, which are optimal with respect to worst-case complexity. Notably, such deductive methods can be considered as generalizations of known methods for reasoning in nonmonotonic formalisms such as default logic, autoepistemic logic, and logic programming under stable model semantics.

We also show that the "negation as failure" modality in MBNF exactly corresponds to negative introspection in autoepistemic logic (Moore, 1985). This result implies that the logic MBNF can be considered as the "composition" of two epistemic modalities: the
"minimal knowledge" operator due to Halpern and Moses (1985) and Moore's autoepistemic operator.

Besides its theoretical interest, we believe that such a computational and epistemological analysis of MBNF has interesting implications for the development of knowledge representtion systems with nonmonotonic abilities, since it allows for a better understanding and comparison of the different nonmonotonic formalisms captured by MBNF. The interest in defining deductive methods for MBNF also arises from the fact that such a logic, originally developed as a framework for the comparison of different logical approaches to nonmonotonic reasoning, has recently been considered as an attractive knowledge representation formalism. In particular, it has been shown (Donini, Nardi, & Rosati, 1997a) that the full power of MBNF is necessary in order to logically formalize several features of implemented frame-based knowledge representation systems.

In the following, we first briefly recall the logic MBNF. In Section 3 we address the relationship between MBNF and Moore's autoepistemic logic. Then, in Section 4 we study the problem of reasoning in propositional MBNF: we first consider the case of general MBNF theories, then we deal with flat MBNF theories. In Section 5 we present the computational