# Planning Graph As A (Dynamic) Csp: Exploiting Ebl, Ddb And Other Csp Search Techniques In Graphplan

Subbarao Kambhampati RAO@ASU.EDU
Department of Computer Science and Engineering Arizona State University, Tempe AZ 85287-5406

## Abstract

This paper reviews the connections between Graphplan's planning-graph and the dynamic constraint satisfaction problem and motivates the need for adapting CSP search techniques to the Graphplan algorithm. It then describes how explanation based learning, dependency directed backtracking, dynamic variable ordering, forward checking, sticky values and random-restart search strategies can be adapted to Graphplan. Empirical results are provided to demonstrate that these augmentations improve Graphplan's performance significantly (up to 1000x speedups)on several benchmark problems. Special attention is paid to the explanation-based learning and dependency directed backtracking techniques as they are empirically found to be most useful in improving the performance of Graphplan.

## 1. Introduction

Graphplan (Blum & Furst, 1997) is currently one of the more efficient algorithms for solving classical planning problems. Four of the five competing systems in the recent AIPS-98 planning competition were based on the Graphplan algorithm (McDermott, 1998). Extending the efficiency of the Graphplan algorithm thus seems to be a worth-while activity. In (Kambhampati, Parker, &
Lambrecht, 1997), we provided a reconstruction of Graphplan algorithm to explicate its links to previous work in classical planning and constraint satisfaction. One specific link that was discussed is the connection between the process of searching Graphplan's planning graph, and solving a "dynamic constraint satisfaction problem" (DCSP) (Mittal & Falkenhainer, 1990). Seen from the DCSP
perspective, the standard backward search proposed by Blum and Furst (1997) lacks a variety of ingredients that are thought to make up efficient CSP search mechanisms (Frost & Dechter, 1994; Bayardo & Schrag, 1997). These include forward checking, dynamic variable ordering, dependency directed backtracking and explanation-based learning (Tsang, 1993; Kambhampati, 1998).

In (Kambhampati et al., 1997), I have suggested that it would be beneficial to study the impact of these extensions on the effectiveness of Graphplan's backward search.

In this paper, I describe my experiences with adding a variety of CSP search techniques to improve Graphplan backward search–including explanation-based learning (EBL) and dependencydirected backtracking capabilities (DDB), Dynamic variable ordering, Forward checking, sticky values, and random-restart search strategies. Of these, the addition of EBL and DDB capabilities turned out to be empirically the most useful. Both EBL and DDB are based on explaining failures at the leaf-nodes of a search tree, and propagating those explanations upwards through the search tree (Kambhampati, 1998). DDB involves using the propagation of failure explanations to support intelligent backtracking, while EBL involves storing interior-node failure explanations, for pruning future search nodes. Graphplan does use a weak form of failure-driven learning that it calls "mem-