the backtracking–so it makes sense to restore this value upon re-visit. In the example above, this heuristic will remember that v7 was the current value of P i m when we backtracked over it, and tries that as the first value when it is re-visited. A variation on this technique is to re-arrange or *fold* the domain of the variable such that all the values that precede the current value are sent to the back of the domain, so that these values will be tried only if other previously untried values are found to fail. This makes the assumption that the values that led to failure once are likely to do so again. In the example above, this heuristic folds the domain of P i m so it becomes v7; v8    vk; v1; v2    v6 .

Notice that both these heuristics make sense only if we employ DDB, as otherwise we will never skip over any variable during backtracking.

I implemented both sticky value heuristics on top of EBL/DDB for Graphplan. The statistics in Table 3 show the results of experiments with this extension. As can be seen, the sticky values approach is able to give up to 4.6x additional speedup over EBL/DDB depending on the problem.

Further, while the folding heuristic dominates the simple version in terms of number of backtracks, the difference is quite small in terms of run-time.

## 7. Forward Checking & Dynamic Variable Ordering

DDB and EBL are considered "look-back" techniques in that they analyze the failures by looking back at the past variables that may have played a part in those failures. There is a different class of techniques known as "look-forward" techniques for improving search. Prominent among these latter are forward checking and dynamic variable ordering. Supporting forward checking involves filtering out the conflicting actions from the domains of the remaining goals, as soon as a particular goal is assigned. In the example in Figure 1, forward checking will filter A9 from the domain of P4 as soon as P1 is assigned A5. Dynamic variable ordering (DVO) involves selecting for assignment the goal that has the least number of remaining establishers.

17 When DVO is combined with forward checking, the variables are ordered according to their "live" domain sizes (where live domain is comprised of values from the domain that are not yet pruned by forward checking). Our experiments18 show that these techniques can bring about reasonable, albeit non-dramatic, improvements in Graphplan's performance. Table 4 shows the statistics for some benchmark problems, with dynamic variable ordering alone, and with forward checking and dynamic variable ordering. We note that while the backtracks reduce by up to 3.6x in the case of dynamic variable ordering, and 5x in the case of dynamic variable ordering and forward checking, the speedups in time are somewhat smaller, ranging only from 1.1x to 4.8x. Times can perhaps be improved further with a more efficient implementation of forward checking.19 The results also seem to suggest that no amount of optimization is going to make dynamic variable ordering and forward checking competitive with EBL/DDB on other problems. For one thing, there are several problems, including Att-log-a, Tsp-12, Ferry-6 etc.

which just could not be solved even with forward checking and dynamic variable ordering. Second, even on the problems that could be solved, the reduction in backtracks provided by EBL/DDB is far greater than that provided by FC/DVO strategies. For example, on Tsp-10, the FC/DVO strategies